/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.RegistrationInfo;
import com.pvsstudio.rules.IssuesLoaderSensor;
import com.pvsstudio.utils.LicenseFile;
import com.pvsstudio.utils.PvsUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Registration {
    public static RegistrationInfo checkLicense(String username, String key) {
        return new RegistrationInfo(CoreJNI.LicenseUtils_checkLicense(username, key), true);
    }

    private static void DeleteTempPath(Path path) {
        if (path != null && path.toFile().exists()) {
            path.toFile().delete();
        }
    }

    public static RegistrationState CheckRegistration(String licensePath, String settingsPath, String baseDir) {
        String fixLicensePath;
        Path tempLicFilePath = null;
        boolean licenseFromSettingsXml = false;
        if (licensePath != null) {
            fixLicensePath = PvsUtils.getCorrectPath(licensePath, baseDir);
            if (fixLicensePath == null) {
                IssuesLoaderSensor.LOGGER.debug("License file does not exist: {}", (Object)licensePath);
                return RegistrationState.Invalid;
            }
        } else if (!IssuesLoaderSensor.VerificationByExec) {
            fixLicensePath = Registration.getLicenseDefaultJavaPath();
            if (fixLicensePath == null) {
                IssuesLoaderSensor.LOGGER.debug("License file does not exist: {}", (Object)"PVS-Studio Java Default License");
                return RegistrationState.Invalid;
            }
        } else if (PvsUtils.isUnix() || PvsUtils.isMac()) {
            fixLicensePath = Registration.getLicenseDefaultLinuxPath();
            if (fixLicensePath == null) {
                IssuesLoaderSensor.LOGGER.debug("License file does not exist: {}", (Object)Registration.getLicenseDefaultLinuxPath());
                return RegistrationState.Invalid;
            }
        } else {
            String fixSettingsPath;
            if (settingsPath == null) {
                String defaultSettingsPath = PvsUtils.getDefaultSettingsXmlPath();
                if (defaultSettingsPath == null) {
                    IssuesLoaderSensor.LOGGER.error("Path to analyzer's settings or license wasn't specified, use the following keys: '{}', '{}'", (Object)"sonar.pvs-studio.settingsPath", (Object)"sonar.pvs-studio.licensePath");
                    return RegistrationState.Invalid;
                }
                settingsPath = PvsUtils.getDefaultSettingsXmlPath();
            }
            if ((fixSettingsPath = PvsUtils.getCorrectPath(settingsPath, baseDir)) == null) {
                IssuesLoaderSensor.LOGGER.debug("Settings file does not exist: {}", (Object)settingsPath);
                return RegistrationState.Invalid;
            }
            try {
                block26: {
                    String licenseInfo = Registration.getLicenseInfoFromSettingsXml(fixSettingsPath);
                    if (licenseInfo != null) {
                        tempLicFilePath = Files.createTempFile(null, ".lic", new FileAttribute[0]);
                        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tempLicFilePath.toFile().toPath(), new OpenOption[0]), "UTF-8"));){
                            out.write(licenseInfo);
                            break block26;
                        }
                        catch (Exception e) {
                            IssuesLoaderSensor.LOGGER.debug("PVS-Studio License wasn't saved in {}", (Object)tempLicFilePath);
                            return RegistrationState.Invalid;
                        }
                    }
                    IssuesLoaderSensor.LOGGER.debug("PVS-Studio License wasn't found in {}", (Object)fixSettingsPath);
                    return RegistrationState.Invalid;
                }
                fixLicensePath = tempLicFilePath.toFile().getPath();
                licenseFromSettingsXml = true;
            }
            catch (Exception e) {
                IssuesLoaderSensor.LOGGER.debug(e.toString());
                return RegistrationState.Invalid;
            }
        }
        if (!IssuesLoaderSensor.VerificationByExec) {
            String javaNativePath = PvsUtils.getPvsStudioLibraryPath();
            if (javaNativePath == null) {
                IssuesLoaderSensor.LOGGER.error("Unload PVS-Studio Java Library.");
                Registration.DeleteTempPath(tempLicFilePath);
                return RegistrationState.Invalid;
            }
            LicenseFile licenseFile = Registration.getLicenseInfoFromLicFile(fixLicensePath);
            IssuesLoaderSensor.LOGGER.debug("PVS-Studio for Java was found.");
            System.load(javaNativePath);
            IssuesLoaderSensor.LOGGER.debug("PVS-Studio check license: {}", (Object)fixLicensePath);
            RegistrationInfo info = Registration.checkLicense(licenseFile.Name, licenseFile.Key);
            if (info.getValid() && info.isEnterpriseLicense()) {
                IssuesLoaderSensor.LOGGER.info("PVS-Studio License File: {}", (Object)fixLicensePath);
                IssuesLoaderSensor.PvsStudioValidDays = info.getDaysLeft();
                Registration.DeleteTempPath(tempLicFilePath);
                return RegistrationState.Valid;
            }
            if (info.getValid() && !info.isEnterpriseLicense()) {
                IssuesLoaderSensor.LOGGER.info("PVS-Studio License File: {}", (Object)fixLicensePath);
                Registration.DeleteTempPath(tempLicFilePath);
                return RegistrationState.NotEnterprise;
            }
            Registration.DeleteTempPath(tempLicFilePath);
            return RegistrationState.Invalid;
        }
        IssuesLoaderSensor.LOGGER.debug("PVS-Studio for C, C++, and C# was found.");
        IssuesLoaderSensor.LOGGER.info("PVS-Studio License File: {}", (Object)(licenseFromSettingsXml ? settingsPath : fixLicensePath));
        RegistrationState registrationState = Registration.checkLicenseFile(fixLicensePath);
        Registration.DeleteTempPath(tempLicFilePath);
        return registrationState;
    }

    private static RegistrationState checkLicenseFile(String licensePath) {
        IssuesLoaderSensor.LOGGER.debug("Checking PVS-Studio license: {}", (Object)(licensePath == null ? "<default>" : licensePath));
        List<String> licenseOutput = PvsUtils.execConsoleRequest(Registration.getPvsStudioCheckRegCmd(PvsUtils.getPvsStudioExecutablePath(), licensePath));
        if (licenseOutput.size() == 3) {
            String registrationState = licenseOutput.get(0);
            if (!registrationState.equalsIgnoreCase("Valid")) {
                return RegistrationState.Invalid;
            }
            String licenseType = licenseOutput.get(1);
            if (!licenseType.equalsIgnoreCase("Enterprise License")) {
                return RegistrationState.NotEnterprise;
            }
            long date = Long.parseLong(licenseOutput.get(2));
            if (Registration.isTimedOut(date)) {
                return RegistrationState.Invalid;
            }
            IssuesLoaderSensor.PvsStudioValidDays = Registration.getDaysLeft(date);
            if (IssuesLoaderSensor.PvsStudioValidDays > 0L) {
                return RegistrationState.Valid;
            }
            return RegistrationState.Invalid;
        }
        return RegistrationState.Invalid;
    }

    private static boolean isTimedOut(long date) {
        return date < System.currentTimeMillis() / 1000L;
    }

    private static long getDaysLeft(long date) {
        return (long)Math.ceil(((double)date - (double)System.currentTimeMillis() / 1000.0) / 86400.0);
    }

    private static String[] getPvsStudioCheckRegCmd(String executable, String licensePath) {
        boolean bLicFile;
        boolean bl = bLicFile = licensePath != null && !licensePath.isEmpty();
        if (PvsUtils.isWindows()) {
            if (!bLicFile) {
                return new String[]{executable, "--checkreg=yes"};
            }
            return new String[]{executable, "--checkreg=yes", "--lic-file", licensePath};
        }
        if (PvsUtils.isUnix() || PvsUtils.isMac()) {
            if (!bLicFile) {
                return new String[]{"pvs-studio", "--checkreg", "yes"};
            }
            return new String[]{"pvs-studio", "--checkreg", "yes", "--lic-file", licensePath};
        }
        IssuesLoaderSensor.LOGGER.error("Your OS is not supported!");
        return null;
    }

    public static String getLicenseInfoFromSettingsXml(String settingsPath) throws ParserConfigurationException, IOException, SAXException {
        String licenseInfo = null;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(settingsPath));
        doc.getDocumentElement().normalize();
        String userName = PvsUtils.getNodeValueByTagName(doc, "UserName");
        String serialNumber = PvsUtils.getNodeValueByTagName(doc, "SerialNumber");
        if (userName != null && serialNumber != null) {
            licenseInfo = userName + System.lineSeparator() + serialNumber;
        }
        return licenseInfo;
    }

    public static LicenseFile getLicenseInfoFromLicFile(String licenseFile) {
        LicenseFile result = new LicenseFile();
        try {
            FileReader fileReader = new FileReader(licenseFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            result.Name = line != null ? line : "";
            line = bufferedReader.readLine();
            result.Key = line != null ? line : "";
            bufferedReader.close();
        }
        catch (IOException ex) {
            return result;
        }
        return result;
    }

    public static String getLicenseDefaultJavaPath() {
        return Registration.getLicenseDefaultPath("PVS-Studio-Java");
    }

    public static String getLicenseDefaultLinuxPath() {
        return Registration.getLicenseDefaultPath("PVS-Studio");
    }

    private static String getLicenseDefaultPath(String pvsDirectory) {
        String homeDirectory = System.getenv(PvsUtils.isWindows() ? "AppData" : "HOME");
        if (homeDirectory == null || homeDirectory.isEmpty()) {
            IssuesLoaderSensor.LOGGER.debug("Home/AppData directory wasn't found.");
            return null;
        }
        String path = homeDirectory + File.separator + (PvsUtils.isWindows() ? pvsDirectory + File.separator + "PVS-Studio.lic" : ".config" + File.separator + pvsDirectory + File.separator + "PVS-Studio.lic");
        IssuesLoaderSensor.LOGGER.debug("Home/AppData directory wasn't found.");
        File home = new File(path);
        if (home.exists() && home.isFile()) {
            return home.getAbsolutePath();
        }
        IssuesLoaderSensor.LOGGER.debug("License file does not exist: {}", (Object)path);
        return null;
    }

    public static enum RegistrationState {
        Valid,
        Invalid,
        NotEnterprise;

    }
}

