/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

import com.pvsstudio.rules.IssuesLoaderSensor;
import com.pvsstudio.utils.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PlogMessage
extends Message<Element> {
    public PlogMessage(boolean bCwe, boolean bMisra) {
        super(bCwe, bMisra);
    }

    @Override
    public String getMessageForSonarQubeIssue(Element eElement) {
        return this.errorCode + ": " + eElement.getElementsByTagName("Message").item(0).getTextContent();
    }

    public static List<PlogMessage> GetMessagesFromReport(File report, String baseDir, String sourceTreeRoot, boolean pvsDisplayCwe, boolean pvsDisplayMisra) {
        IssuesLoaderSensor.LOGGER.info("Reading PVS-Studio Report: {}", (Object)report.getAbsolutePath());
        ArrayList<PlogMessage> plogMessages = new ArrayList<PlogMessage>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        long failWarningsCount = 0L;
        long falseAlarmCount = 0L;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document plogDoc = dBuilder.parse(report);
            plogDoc.getDocumentElement().normalize();
            NodeList nList = plogDoc.getElementsByTagName("PVS-Studio_Analysis_Log");
            for (int nodeCount = 0; nodeCount < nList.getLength(); ++nodeCount) {
                PlogMessage msg;
                Element eElement;
                block18: {
                    String filePath;
                    Node nNode = nList.item(nodeCount);
                    if (nNode.getNodeType() != 1) continue;
                    eElement = (Element)nNode;
                    msg = new PlogMessage(pvsDisplayCwe, pvsDisplayMisra);
                    msg.errorCode = "";
                    NodeList nodeErrorCode = eElement.getElementsByTagName("ErrorCode");
                    if (nodeErrorCode != null && nodeErrorCode.item(0) != null && nodeErrorCode.item(0).getTextContent() != null) {
                        msg.errorCode = nodeErrorCode.item(0).getTextContent().trim();
                    }
                    if ("Renew".equalsIgnoreCase(msg.errorCode) || "Update".equalsIgnoreCase(msg.errorCode)) {
                        IssuesLoaderSensor.LOGGER.debug(msg.errorCode + " message from file {} is skipped.", (Object)report.getAbsolutePath());
                        continue;
                    }
                    if (msg.errorCode.isEmpty() || !msg.errorCode.startsWith("V")) {
                        ++failWarningsCount;
                        continue;
                    }
                    NodeList nodeFalseAlarm = eElement.getElementsByTagName("FalseAlarm");
                    if (nodeFalseAlarm != null && nodeFalseAlarm.item(0) != null && nodeFalseAlarm.item(0).getTextContent().equalsIgnoreCase("true")) {
                        ++falseAlarmCount;
                        continue;
                    }
                    NodeList nodeCwe = eElement.getElementsByTagName("CWECode");
                    msg.cweCategory = nodeCwe != null && nodeCwe.item(0) != null && nodeCwe.item(0).getTextContent().startsWith("CWE-") ? nodeCwe.item(0).getTextContent() : "";
                    NodeList nodeMisra = eElement.getElementsByTagName("SAST");
                    msg.misraCategory = nodeMisra != null && nodeMisra.item(0) != null && nodeMisra.item(0).getTextContent().startsWith("MISRA") ? nodeMisra.item(0).getTextContent() : "";
                    msg.setIsOWASPWarning(nodeMisra != null && nodeMisra.item(0) != null && nodeMisra.item(0).getTextContent().startsWith("OWASP-"));
                    msg.falseAlarm = "false";
                    msg.file = "";
                    NodeList nodeFile = eElement.getElementsByTagName("File");
                    if (nodeFile != null && nodeFile.item(0) != null && nodeFile.item(0).getTextContent() != null) {
                        msg.file = nodeFile.item(0).getTextContent().trim();
                    }
                    if ((filePath = PlogMessage.formMessageFilePath(msg.file, sourceTreeRoot, baseDir)) == null) {
                        ++failWarningsCount;
                        continue;
                    }
                    msg.file = filePath;
                    msg.message = msg.getMessageForSonarQubeIssue(eElement);
                    msg.level = eElement.getElementsByTagName("Level").item(0).getTextContent();
                    if (msg.file.isEmpty() && !PlogMessage.isSpecialDiagnostic(msg.errorCode)) {
                        IssuesLoaderSensor.LOGGER.warn("Source code file not found: {}", (Object)msg.getIssueLoggerRepresentation(eElement));
                        continue;
                    }
                    try {
                        msg.lineNumber = Integer.parseInt(eElement.getElementsByTagName("Line").item(0).getTextContent());
                        if (msg.lineNumber < 0) {
                            IssuesLoaderSensor.LOGGER.warn("Not positive LineNumber found: {}", (Object)msg.toString());
                            ++failWarningsCount;
                        }
                        break block18;
                    }
                    catch (NumberFormatException e) {
                        IssuesLoaderSensor.LOGGER.warn("[msg.lineNumber] NumberFormatException in: {}", (Object)msg.toString());
                        ++failWarningsCount;
                    }
                    continue;
                }
                NodeList lineExtensionNode = eElement.getElementsByTagName("LineExtension");
                String lines = lineExtensionNode != null && lineExtensionNode.item(0) != null ? lineExtensionNode.item(0).getTextContent() : "";
                msg.lineExtension = new ArrayList();
                try {
                    for (String textValue : lines.split(",")) {
                        if (textValue.isEmpty()) continue;
                        Integer ln = Integer.valueOf(textValue);
                        if (ln < 0) {
                            IssuesLoaderSensor.LOGGER.warn("Not positive LineExtension found: {}", (Object)msg.toString());
                            ++failWarningsCount;
                            continue;
                        }
                        msg.lineExtension.add(Integer.valueOf(textValue));
                    }
                }
                catch (NumberFormatException e) {
                    IssuesLoaderSensor.LOGGER.warn("[msg.lineExtension] NumberFormatException in: {}", (Object)msg.toString());
                    ++failWarningsCount;
                    continue;
                }
                msg.positions = msg.parsePositions(eElement, sourceTreeRoot, baseDir);
                plogMessages.add(msg);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            PlogMessage.logParserExceptions(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PlogMessage.logParsedMessages(plogMessages, falseAlarmCount, failWarningsCount);
        return plogMessages;
    }

    @Override
    protected List<Message.Position> parsePositions(Element eElement, String sourceTreeRoot, String baseDir) {
        String LINE_SEPARATOR = Message.Position.LINES_SEPARATOR.toString();
        String POSITION_ATTRIBUTE_NAME = "lines";
        String POSITION_ELEMENT_NAME = "Position";
        if (eElement == null) {
            return Collections.emptyList();
        }
        NodeList positionNodes = eElement.getElementsByTagName("Position");
        if (positionNodes == null || positionNodes.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Message.Position> result = new ArrayList<Message.Position>();
        for (int i = 0; i < positionNodes.getLength(); ++i) {
            String linesStr;
            Node linesAttribute;
            NamedNodeMap attributes;
            String filePath;
            Node positionContent;
            NodeList childNodes;
            Node positionNode = positionNodes.item(i);
            if (positionNode == null || (childNodes = positionNode.getChildNodes()).getLength() != 1 || (positionContent = childNodes.item(0)).getNodeType() != 3 || (filePath = positionContent.getNodeValue()) == null || filePath.isEmpty() || (filePath = PlogMessage.formMessageFilePath(filePath, sourceTreeRoot, baseDir)) == null || (attributes = positionNode.getAttributes()) == null || (linesAttribute = attributes.getNamedItem("lines")) == null || (linesStr = linesAttribute.getNodeValue()) == null || linesStr.isEmpty()) continue;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            for (String line : linesStr.split(LINE_SEPARATOR)) {
                try {
                    lines.add(Integer.parseInt(line));
                }
                catch (NumberFormatException e) {
                    IssuesLoaderSensor.LOGGER.warn("Invalid content of the '{}' attribute of the '{}' element.", (Object)"lines", (Object)"Position");
                }
            }
            result.add(new Message.Position(filePath, lines));
        }
        return result;
    }
}

