/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.measures.PvsMetrics;
import com.pvsstudio.utils.AnalyzerType;
import com.pvsstudio.utils.JsonMessage;
import com.pvsstudio.utils.Message;
import com.pvsstudio.utils.PlogMessage;
import com.pvsstudio.utils.PvsUtils;
import com.pvsstudio.utils.Registration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.fs.InputProject;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class IssuesLoaderSensor
implements Sensor {
    public static final Logger LOGGER = Loggers.get(IssuesLoaderSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.pvs-studio.reportPath";
    public static final String SETTINGS_PATH_KEY = "sonar.pvs-studio.settingsPath";
    public static final String SOURCE_TREE_ROOT_KEY = "sonar.pvs-studio.sourceTreeRoot";
    public static final String LICENSE_PATH_KEY = "sonar.pvs-studio.licensePath";
    public static final String PVS_DISPLAY_MISRA_KEY = "sonar.pvs-studio.misra";
    public static final String PVS_DISPLAY_CWE_KEY = "sonar.pvs-studio.cwe";
    public static boolean VerificationByExec = true;
    public static boolean notCompatibleVersion = false;
    public static long PvsStudioValidDays = -1L;
    private static final Version LATEST_SUPPORTED_VERSION_OF_SONARQUBE_PLUGIN_API_BEFORE_10_2 = Version.parse((String)"9.17.0.587");
    protected final Configuration config;
    public final FileSystem fileSystem;
    protected SensorContext context;
    protected ActiveRules activeRules;
    private String currentCxxCommunityRepoKey = null;

    public IssuesLoaderSensor(Configuration config, FileSystem fileSystem, ActiveRules activeRules) {
        this.config = config;
        this.fileSystem = fileSystem;
        this.activeRules = activeRules;
    }

    protected Version getLastSupportedAndTestedSonarQubePluginAPI() {
        return LATEST_SUPPORTED_VERSION_OF_SONARQUBE_PLUGIN_API_BEFORE_10_2;
    }

    private void showInLogCurrentSonarQubeInfoOrPluginPossibleUnsupportedMessage() {
        Version currentSonarQubePluginApiVersion = this.context.runtime().getApiVersion();
        String currentSonarQubeInfoMessage = this.getCurrentSonarQubeInfoMessage(currentSonarQubePluginApiVersion);
        if (currentSonarQubePluginApiVersion.compareTo(this.getLastSupportedAndTestedSonarQubePluginAPI()) <= 0) {
            LOGGER.info(currentSonarQubeInfoMessage);
        } else {
            LOGGER.warn("The PVS-Studio plugin may not be supported by the current version of SonarQube. " + currentSonarQubeInfoMessage);
        }
    }

    protected String getCurrentSonarQubeInfoMessage(Version currentSonarQubePluginApiVersion) {
        return this.getSonarQubePluginAPIMessage(currentSonarQubePluginApiVersion);
    }

    protected final String getSonarQubePluginAPIMessage(Version currentSonarQubePluginApiVersion) {
        return "SonarQube Plugin API Version: " + currentSonarQubePluginApiVersion;
    }

    public String toString() {
        return "PVS-Studio Issues Loader Sensor";
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("PVS-Studio Issues Loader Sensor");
        descriptor.onlyOnLanguages(new String[]{"c++", "cxx", "cs", "java", "c/c++/c#", "c", "cpp"});
    }

    public void execute(SensorContext context) {
        this.context = context;
        if (!this.config.hasKey(this.reportPathKey())) {
            LOGGER.warn("Path to PVS-Studio report wasn't specified, use the following key: '{}'", (Object)this.reportPathKey());
            return;
        }
        if (PvsUtils.getPvsStudioExecutablePath() != null) {
            VerificationByExec = true;
        } else if (PvsUtils.getPvsStudioLibraryPath() != null) {
            VerificationByExec = false;
        } else {
            String message = "PVS-Studio is not installed" + (PvsUtils.isWindows() ? "!" : " or not found in the PATH system variable!");
            throw new IllegalStateException(message);
        }
        if (!PvsUtils.pvsCompatibleVersions()) {
            notCompatibleVersion = true;
        }
        if (!this.isEnterpriseLicence()) {
            throw new IllegalStateException();
        }
        List<File> reports = this.getReports();
        if (reports.isEmpty()) {
            LOGGER.warn("Analyser's results are empty : '{}'", (Object)this.reportPathKey());
            return;
        }
        this.showInLogCurrentSonarQubeInfoOrPluginPossibleUnsupportedMessage();
        this.parseAndSaveResults(reports);
    }

    public List<File> getReports() {
        String[] reportPaths;
        ArrayList<File> reports = new ArrayList<File>();
        for (String path : reportPaths = this.config.getStringArray(REPORT_PATH_KEY)) {
            String reportPath = PvsUtils.getCorrectPath(path, this.fileSystem.baseDir().getPath());
            if (reportPath == null) {
                LOGGER.warn("Analysis report doesn't exist: {}", (Object)path);
                continue;
            }
            reports.add(new File(reportPath));
        }
        return reports;
    }

    public String getRepositoryKey(String errorCode, String language) {
        language = Message.getLanguageFromErrorCode_if_isSpecialDiagnostic(errorCode, language);
        if (errorCode.equals("VTEST")) {
            return "pvs-studio-csharp-only";
        }
        if ("c/c++/c#".equals(language)) {
            return "pvs-studio-cpp";
        }
        if ("cs".equals(language)) {
            return "pvs-studio-csharp-only";
        }
        if ("java".equals(language)) {
            return "pvs-studio-java-only";
        }
        if ("cpp".equals(language)) {
            return "pvs-studio-cpp-family";
        }
        if ("c".equals(language)) {
            return "pvs-studio-c-family";
        }
        if ("c++".equals(language) || "cxx".equals(language)) {
            if (this.currentCxxCommunityRepoKey != null) {
                return this.currentCxxCommunityRepoKey;
            }
            Collection activeRulesForLanguage = this.activeRules.findByLanguage(language);
            if (activeRulesForLanguage.isEmpty()) {
                return null;
            }
            Optional<ActiveRule> firstActiveRule = activeRulesForLanguage.stream().filter(rule -> rule.ruleKey().rule().equals(errorCode)).findFirst();
            if (firstActiveRule.isPresent()) {
                this.currentCxxCommunityRepoKey = firstActiveRule.get().ruleKey().repository();
                return this.currentCxxCommunityRepoKey;
            }
            return null;
        }
        LOGGER.error("Unknown repo language: " + language);
        throw new IllegalStateException("Unknown repo language: " + language);
    }

    protected void parseAndSaveResults(List<File> reports) {
        String sourceTreeRootPath = this.getSourceTreeRootPath();
        if (PvsUtils.isWindows() && sourceTreeRootPath == null && this.getSettingsPath() != null) {
            sourceTreeRootPath = PvsUtils.getSourceTreeRootFromSettings(this.getSettingsPath(), this.fileSystem.baseDir().getAbsolutePath());
        }
        LOGGER.debug("PVS-Studio SourceTreeRoot: {}", (Object)sourceTreeRootPath);
        List<Object> errors = new ArrayList();
        block11: for (File analysisResultsFile : reports) {
            String reportExtension = PvsUtils.getExtension(analysisResultsFile.getName());
            switch (reportExtension) {
                case "json": {
                    errors.addAll(JsonMessage.GetMessagesFromReport(analysisResultsFile, this.fileSystem.baseDir().getAbsolutePath(), sourceTreeRootPath, this.isDisplayCwe(), this.isDisplayMisra()));
                    continue block11;
                }
                case "plog": 
                case "xml": {
                    errors.addAll(PlogMessage.GetMessagesFromReport(analysisResultsFile, this.fileSystem.baseDir().getAbsolutePath(), sourceTreeRootPath, this.isDisplayCwe(), this.isDisplayMisra()));
                    continue block11;
                }
            }
            LOGGER.error("Unexpected report file format {}. The supported report formats are '*.plog' or '*.json'", (Object)reportExtension);
        }
        int mCount = errors.size();
        if ((errors = errors.stream().filter(PvsUtils.distinctByKey(Message::getHash)).collect(Collectors.toList())).size() < mCount) {
            LOGGER.warn("Number of removed duplicated messages: {}", (Object)(mCount - errors.size()));
        } else if (errors.isEmpty()) {
            LOGGER.warn("There aren't any messages in analysis report.");
            return;
        }
        boolean expireLic = PvsStudioValidDays <= 30L;
        Map<String, List<Message>> groupErrors = errors.stream().collect(Collectors.groupingBy(Message::getFilePath));
        for (Map.Entry entry : groupErrors.entrySet()) {
            try {
                InputComponent inputComponent = this.getInputFile((String)entry.getKey());
                if (inputComponent != null) {
                    if (expireLic && inputComponent.isFile()) {
                        this.saveRenewIssue((InputFile)inputComponent);
                        expireLic = false;
                    }
                    if (notCompatibleVersion && inputComponent.isFile()) {
                        this.saveCompatibleVersionIssue((InputFile)inputComponent);
                        notCompatibleVersion = false;
                    }
                    if (inputComponent.isFile() && ((InputFile)inputComponent).language() == null) {
                        LOGGER.warn("Strange lang for file: " + inputComponent.key());
                        continue;
                    }
                    for (Message error : (List)entry.getValue()) {
                        this.saveIssue(inputComponent, error);
                    }
                    boolean isProjectComponent = inputComponent instanceof InputProject;
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_ALL_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_ALL_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(((List)entry.getValue()).size())).save();
                    int cweCount = (int)((List)entry.getValue()).stream().filter(x -> !x.cweCategory.isEmpty()).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_CWE_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_CWE_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(cweCount)).save();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_CWE_WARNINGS_SECR_FOR_PROJECT : PvsMetrics.PVS_CWE_WARNINGS_SECR).on(inputComponent).withValue((Serializable)Integer.valueOf(cweCount)).save();
                    int misraCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.MISRA).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_MISRA_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_MISRA_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(misraCount)).save();
                    int autosarCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.AUTOSAR).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_AUTOSAR_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_AUTOSAR_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(autosarCount)).save();
                    int owaspCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.OWASP).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_OWASP_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_OWASP_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(owaspCount)).save();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_OWASP_WARNINGS_SECR_FOR_PROJECT : PvsMetrics.PVS_OWASP_WARNINGS_SECR).on(inputComponent).withValue((Serializable)Integer.valueOf(owaspCount)).save();
                    int gaCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.General).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_GA_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_GA_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(gaCount)).save();
                    int viva64Count = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.Viva64).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_64_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_64_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(viva64Count)).save();
                    int opCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.Optimization).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_OP_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_OP_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(opCount)).save();
                    int csCount = (int)((List)entry.getValue()).stream().filter(x -> AnalyzerType.GetAnalyzerType(x.errorCode) == AnalyzerType.CustomerSpecific).count();
                    this.context.newMeasure().forMetric(isProjectComponent ? PvsMetrics.PVS_CS_WARNINGS_FOR_PROJECT : PvsMetrics.PVS_CS_WARNINGS).on(inputComponent).withValue((Serializable)Integer.valueOf(csCount)).save();
                    continue;
                }
                LOGGER.warn("All warnings will be skipped from the source file that is missing from the 'sonar.sources' property: " + (String)entry.getKey());
            }
            catch (Exception e) {
                LOGGER.error("Can not add warnings for file " + (String)entry.getKey() + ":\n" + e.getMessage());
            }
        }
    }

    public static Severity getIssueSeverityFromMessageLevel(Message.MessageLevel reportMessageLevel) {
        switch (reportMessageLevel) {
            case Fails: {
                return Severity.INFO;
            }
            case High: {
                return Severity.CRITICAL;
            }
            case Medium: {
                return Severity.MAJOR;
            }
            case Low: {
                return Severity.MINOR;
            }
        }
        return Severity.BLOCKER;
    }

    public void setSeverityForPluginLoadedMessage(NewIssue newIssue, Message<?> message) {
        newIssue.overrideSeverity(IssuesLoaderSensor.getIssueSeverityFromMessageLevel(message.getSeverity()));
    }

    public void setSeverityForPluginGeneratedMessage(NewIssue newIssue, Message.MessageLevel messageLevel) {
        newIssue.overrideSeverity(IssuesLoaderSensor.getIssueSeverityFromMessageLevel(messageLevel));
    }

    protected void saveCompatibleVersionIssue(InputFile inputFile) {
        String message = "Incompatible versions: Your version of PVS-Studio is higher than the version of PVS-Studio plugin for sonarqube. This may cause errors.";
        String errorCode = "NotCompatibleVersion";
        String repositoryKey = this.getRepositoryKey("NotCompatibleVersion", inputFile.language());
        if (repositoryKey == null) {
            return;
        }
        NewIssue newIssue = this.context.newIssue().forRule(RuleKey.of((String)repositoryKey, (String)"NotCompatibleVersion"));
        this.setSeverityForPluginGeneratedMessage(newIssue, Message.MessageLevel.Unknown);
        NewIssueLocation primaryLocation = newIssue.newLocation().on((InputComponent)inputFile).message("Incompatible versions: Your version of PVS-Studio is higher than the version of PVS-Studio plugin for sonarqube. This may cause errors.").at(inputFile.selectLine(1));
        newIssue.at(primaryLocation).save();
    }

    protected void saveIssue(InputComponent inputComponent, Message<?> plogMessage) {
        String language = inputComponent.isFile() ? ((InputFile)inputComponent).language() : "";
        String repositoryKey = this.getRepositoryKey(plogMessage.errorCode, language);
        if (repositoryKey == null) {
            return;
        }
        NewIssue newIssue = this.context.newIssue().forRule(RuleKey.of((String)repositoryKey, (String)plogMessage.errorCode));
        this.setSeverityForPluginLoadedMessage(newIssue, plogMessage);
        NewIssueLocation primaryLocation = newIssue.newLocation().on(inputComponent).message(plogMessage.getDescription());
        newIssue = inputComponent.isFile() ? this.setLocations(plogMessage, newIssue, primaryLocation, (InputFile)inputComponent) : this.setLocations(newIssue, primaryLocation, (InputProject)inputComponent);
        newIssue.save();
    }

    protected void saveRenewIssue(InputFile inputFile) {
        String message = "Renew: Your license will expire in " + PvsStudioValidDays + " days. Click 'Renew' to learn more or contact us at support@viva64.com. This is an information message. You can continue using the analyzer with your current license.";
        LOGGER.warn(message);
        String errorCode = "Renew";
        String repositoryKey = this.getRepositoryKey("Renew", inputFile.language());
        if (repositoryKey == null) {
            return;
        }
        NewIssue newIssue = this.context.newIssue().forRule(RuleKey.of((String)repositoryKey, (String)"Renew"));
        this.setSeverityForPluginGeneratedMessage(newIssue, Message.MessageLevel.Unknown);
        NewIssueLocation primaryLocation = newIssue.newLocation().on((InputComponent)inputFile).message(message).at(inputFile.selectLine(1));
        newIssue.at(primaryLocation).save();
    }

    private InputComponent getInputFile(String filePath) {
        String file = filePath;
        if (filePath.isEmpty()) {
            return this.context.project();
        }
        if (PvsUtils.isWindows()) {
            try {
                file = new File(filePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.fileSystem.inputFile(this.fileSystem.predicates().and(this.fileSystem.predicates().hasAbsolutePath(file), this.fileSystem.predicates().hasType(InputFile.Type.MAIN)));
    }

    protected NewIssue setLocations(NewIssue issue, NewIssueLocation primaryLocation, InputProject inputProject) {
        return issue.at(primaryLocation);
    }

    protected NewIssue setLocations(Message<?> plogMessage, NewIssue issue, NewIssueLocation primaryLocation, InputFile inputFile) {
        block5: {
            block4: {
                primaryLocation = primaryLocation.at(inputFile.selectLine(plogMessage.getLine()));
                issue.at(primaryLocation);
                if (plogMessage.lineExtension.size() < 2 || !plogMessage.positions.isEmpty()) break block4;
                for (int i = 1; i < plogMessage.lineExtension.size(); ++i) {
                    issue.addLocation(issue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(plogMessage.lineExtension.get(i).intValue())).message("Line " + plogMessage.lineExtension.get(i)));
                }
                break block5;
            }
            if (!plogMessage.lineExtension.isEmpty() || plogMessage.positions.isEmpty()) break block5;
            for (int i = 0; i < plogMessage.positions.size(); ++i) {
                Message.Position position = plogMessage.positions.get(i);
                String file = position.file;
                if (file == null || position.linesNumbers == null || position.linesNumbers.isEmpty()) continue;
                InputFile filePosition = (InputFile)this.getInputFile(file);
                if (filePosition == null) {
                    LOGGER.warn("Additional warning positions will be skipped from the source file that is missing from the 'sonar.sources' property: " + file + " line numbers in file: " + position.linesNumbers);
                    continue;
                }
                for (Integer lineNumber : position.linesNumbers) {
                    if (i == 0 && file.equals(inputFile.file().getAbsolutePath()) && plogMessage.getLine() == lineNumber.intValue()) continue;
                    issue.addLocation(issue.newLocation().on((InputComponent)filePosition).at(filePosition.selectLine(lineNumber.intValue())).message("Line " + lineNumber));
                }
            }
        }
        return issue;
    }

    public boolean isEnterpriseLicence() {
        Registration.RegistrationState regState = Registration.CheckRegistration(this.getLicensePath(), this.getSettingsPath(), this.fileSystem.baseDir().getPath());
        if (regState != Registration.RegistrationState.Valid) {
            if (regState == Registration.RegistrationState.NotEnterprise) {
                LOGGER.error("SonarQube integration available with an Enterprise license only. Please contact at support@viva64.com to order a license.");
            } else {
                LOGGER.error("Valid PVS-Studio license wasn't found.");
            }
            return false;
        }
        return true;
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String licensePathKey() {
        return LICENSE_PATH_KEY;
    }

    public String getLicensePath() {
        if (!this.config.hasKey(this.licensePathKey())) {
            return null;
        }
        Optional o = this.config.get(this.licensePathKey());
        return o.orElse(null);
    }

    protected String settingsPathKey() {
        return SETTINGS_PATH_KEY;
    }

    public String getSettingsPath() {
        if (!this.config.hasKey(this.settingsPathKey())) {
            return null;
        }
        Optional o = this.config.get(this.settingsPathKey());
        return o.orElse(null);
    }

    protected String sourceTreeRootPathKey() {
        return SOURCE_TREE_ROOT_KEY;
    }

    protected String getSourceTreeRootPath() {
        if (!this.config.hasKey(this.sourceTreeRootPathKey())) {
            return null;
        }
        Optional o = this.config.get(this.sourceTreeRootPathKey());
        return o.orElse(null);
    }

    protected boolean isDisplayCwe() {
        return PvsUtils.booleanPropertyIsSet(this.config, PVS_DISPLAY_CWE_KEY);
    }

    protected boolean isDisplayMisra() {
        return PvsUtils.booleanPropertyIsSet(this.config, PVS_DISPLAY_MISRA_KEY);
    }
}

