/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.measures;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;

public class PvsMetrics
implements Metrics {
    private static final String DOMAIN_PVS_STUDIO = "PVS-Studio";
    public static final Metric<Integer> PVS_ALL_WARNINGS = new Metric.Builder("PVS-STUDIO-CPP", "All Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_ALL_WARNINGS_FOR_PROJECT = new Metric.Builder("PVS-STUDIO-CPP-PROJECT", "All Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setHidden(true).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_CWE_WARNINGS = new Metric.Builder("pvs-studio-cwe", "CWE Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_CWE_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-cwe-project", "CWE Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_MISRA_WARNINGS = new Metric.Builder("pvs-studio-misra", "MISRA Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_MISRA_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-misra-project", "MISRA Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_AUTOSAR_WARNINGS = new Metric.Builder("pvs-studio-autosar", "AUTOSAR Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_AUTOSAR_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-autosar-project", "AUTOSAR Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_OWASP_WARNINGS = new Metric.Builder("pvs-studio-owasp", "OWASP Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_OWASP_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-owasp-project", "OWASP Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_OWASP_WARNINGS_SECR = new Metric.Builder("pvs-studio-owasp-secr", "PVS-Studio OWASP Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain(CoreMetrics.DOMAIN_SECURITY).create();
    public static final Metric<Integer> PVS_OWASP_WARNINGS_SECR_FOR_PROJECT = new Metric.Builder("pvs-studio-owasp-secr-project", "PVS-Studio OWASP Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain(CoreMetrics.DOMAIN_SECURITY).create();
    public static final Metric<Integer> PVS_CWE_WARNINGS_SECR = new Metric.Builder("pvs-studio-cwe-secr", "PVS-Studio CWE Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain(CoreMetrics.DOMAIN_SECURITY).create();
    public static final Metric<Integer> PVS_CWE_WARNINGS_SECR_FOR_PROJECT = new Metric.Builder("pvs-studio-cwe-secr-project", "PVS-Studio CWE Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain(CoreMetrics.DOMAIN_SECURITY).create();
    public static final Metric<Integer> PVS_GA_WARNINGS = new Metric.Builder("pvs-studio-ga", "General Analysis Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_GA_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-ga-project", "General Analysis Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_64_WARNINGS = new Metric.Builder("pvs-studio-64", "64-bit Portability Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_64_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-64-project", "64-bit Portability Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_OP_WARNINGS = new Metric.Builder("pvs-studio-op", "Optimization Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_OP_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-op-project", "Optimization Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_CS_WARNINGS = new Metric.Builder("pvs-studio-cs", "Customer Specific Issues", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setDomain("PVS-Studio").create();
    public static final Metric<Integer> PVS_CS_WARNINGS_FOR_PROJECT = new Metric.Builder("pvs-studio-cs-project", "Customer Specific Issues for project", Metric.ValueType.INT).setDirection(Integer.valueOf(-1)).setQualitative(Boolean.valueOf(true)).setHidden(true).setDomain("PVS-Studio").create();

    static int getProjectIssuesCount(MeasureComputer.MeasureComputerContext context, String metricKey) {
        Measure measure = context.getMeasure(metricKey);
        return measure != null ? measure.getIntValue() : 0;
    }

    public List<Metric> getMetrics() {
        return Arrays.asList(PVS_ALL_WARNINGS, PVS_ALL_WARNINGS_FOR_PROJECT, PVS_CWE_WARNINGS, PVS_CWE_WARNINGS_FOR_PROJECT, PVS_MISRA_WARNINGS, PVS_MISRA_WARNINGS_FOR_PROJECT, PVS_AUTOSAR_WARNINGS, PVS_AUTOSAR_WARNINGS_FOR_PROJECT, PVS_OWASP_WARNINGS, PVS_OWASP_WARNINGS_FOR_PROJECT, PVS_OWASP_WARNINGS_SECR, PVS_OWASP_WARNINGS_SECR_FOR_PROJECT, PVS_CWE_WARNINGS_SECR, PVS_CWE_WARNINGS_SECR_FOR_PROJECT, PVS_GA_WARNINGS, PVS_GA_WARNINGS_FOR_PROJECT, PVS_64_WARNINGS, PVS_64_WARNINGS_FOR_PROJECT, PVS_OP_WARNINGS, PVS_OP_WARNINGS_FOR_PROJECT, PVS_CS_WARNINGS, PVS_CS_WARNINGS_FOR_PROJECT);
    }

    public static void CollectMeasure(MeasureComputer.MeasureComputerContext context, String measureKey, int issuesForProjectComponent) {
        Component.Type componentType = context.getComponent().getType();
        if (componentType != Component.Type.FILE) {
            int result = issuesForProjectComponent;
            for (Measure child : context.getChildrenMeasures(measureKey)) {
                result += child.getIntValue();
            }
            context.addMeasure(measureKey, result);
        }
    }
}

