/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.gson.GsonBuilder;
import com.pvsstudio.rules.CppCommunityRulesRepoInfo;
import com.pvsstudio.rules.RulesRepoInfo;
import com.pvsstudio.utils.PvsUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.sonar.api.config.Configuration;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;

public abstract class BaseRulesDefinition<T extends RuleMetadata>
implements RulesRepoInfo,
RulesDefinition {
    private static final String PVS_WARNINGS_AS_VULNERABILITIES_KEY = "sonar.pvs-studio.treatPVSWarningsAsVulnerabilities";
    private static final String ENABLE_COMPATIBILITY_SONAR_CXX_REPOSITORIES = "sonar.pvs-studio.enableCompatibilitySonarCXXRepositories";
    protected final Configuration config;

    static boolean isCompatibilitySonarCxxRepositories(Configuration config) {
        return PvsUtils.booleanPropertyIsSet(config, ENABLE_COMPATIBILITY_SONAR_CXX_REPOSITORIES);
    }

    private static boolean isPVSWarningsAsVulnerabilities(Configuration config) {
        return PvsUtils.booleanPropertyIsSet(config, PVS_WARNINGS_AS_VULNERABILITIES_KEY);
    }

    protected BaseRulesDefinition(Configuration config) {
        this.config = config;
    }

    public final void define(RulesDefinition.Context context) {
        RuleMetadata[] rules;
        if (this instanceof CppCommunityRulesRepoInfo && BaseRulesDefinition.isCompatibilitySonarCxxRepositories(this.config)) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(this.getPathToRulesJson()), StandardCharsets.UTF_8.name());){
            rules = new GsonBuilder().setLenient().create().fromJson((Reader)reader, this.getDeserializationClass());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + this.getPathToRulesJson(), e);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Json is not valid", e);
        }
        RulesDefinition.NewRepository repository = context.createRepository(this.getREPO_KEY(), this.getREPO_LANG()).setName("PVS-Studio");
        boolean isVulnerability = BaseRulesDefinition.isPVSWarningsAsVulnerabilities(this.config);
        if (rules != null) {
            this.addNonGenericRules((RulesDefinition.NewExtendedRepository)repository, isVulnerability);
            for (RuleMetadata ruleMetadata : rules) {
                this.tryAddRule((RulesDefinition.NewExtendedRepository)repository, ruleMetadata, isVulnerability);
            }
        }
        repository.done();
    }

    protected Class<? extends RuleMetadata[]> getDeserializationClass() {
        return RuleMetadata[].class;
    }

    protected T getRuleMetadataNewInstance() {
        return (T)new RuleMetadata();
    }

    protected void setSpecificInformation(RulesDefinition.NewRule newRule, T ruleMetadata) {
        String trimmedSeverity = this.getTrimmedValue(((RuleMetadata)ruleMetadata).severity, true);
        newRule.setSeverity(trimmedSeverity != null ? trimmedSeverity : Severity.defaultSeverity());
    }

    protected BiConsumer<RulesDefinition.NewRule, RuleMetadata.OwaspTop10Mapping> getOWASPTop10AddAction() {
        return (newRuleDefinition, owaspTop10Mapping) -> newRuleDefinition.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)owaspTop10Mapping.code)});
    }

    private void addOwaspTop10(RulesDefinition.NewRule newRule, T ruleMetadata, BiConsumer<RulesDefinition.NewRule, RuleMetadata.OwaspTop10Mapping> setOWASPForNewRule) {
        try {
            if (setOWASPForNewRule != null) {
                Arrays.stream(((RuleMetadata)ruleMetadata).securityStandards.OWASP).forEach(owaspTop10Mapping -> setOWASPForNewRule.accept(newRule, (RuleMetadata.OwaspTop10Mapping)owaspTop10Mapping));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void tryAddRule(RulesDefinition.NewExtendedRepository repo, T ruleMetadata, boolean isVulnerability) {
        String ruleKey = this.getTrimmedValue(((RuleMetadata)ruleMetadata).key);
        String ruleName = this.getTrimmedValue(((RuleMetadata)ruleMetadata).name);
        String ruleHtmlDescription = this.getTrimmedValue(((RuleMetadata)ruleMetadata).htmlDescription);
        String[] ruleTags = (String[])Stream.of(((RuleMetadata)ruleMetadata).tags).filter(Objects::nonNull).map(String::trim).toArray(String[]::new);
        String ruleType = this.getTrimmedValue(((RuleMetadata)ruleMetadata).type);
        try {
            RulesDefinition.NewRule newRule = repo.createRule(ruleKey).setName(ruleName).setHtmlDescription(ruleHtmlDescription).setTags(ruleTags);
            try {
                newRule.addCwe(((RuleMetadata)ruleMetadata).securityStandards.CWE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isVulnerability && (((RuleMetadata)ruleMetadata).securityStandards.CWE.length > 0 || ((RuleMetadata)ruleMetadata).securityStandards.OWASP.length > 0)) {
                newRule.setType(RuleType.VULNERABILITY);
            } else if (ruleType != null) {
                newRule.setType(RuleType.valueOf((String)ruleType));
            }
            this.setSpecificInformation(newRule, ruleMetadata);
            try {
                Arrays.stream(((RuleMetadata)ruleMetadata).securityStandards.OWASP).forEach(owaspTop10Mapping -> this.getOWASPTop10AddAction().accept(newRule, (RuleMetadata.OwaspTop10Mapping)owaspTop10Mapping));
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to load the rule with key [%s:%s]", repo.key(), ruleKey), e);
        }
    }

    private String getTrimmedValue(String str) {
        return this.getTrimmedValue(str, false);
    }

    protected final String getTrimmedValue(String str, boolean useUSLocaleWithToUpperCase) {
        if (str == null) {
            return null;
        }
        String trimmedResult = str.trim();
        if (useUSLocaleWithToUpperCase) {
            return trimmedResult.toUpperCase(Locale.US);
        }
        return trimmedResult;
    }

    private void addNonGenericRules(RulesDefinition.NewExtendedRepository repo, boolean isVulnerability) {
        T meta = this.getRuleMetadataNewInstance();
        ((RuleMetadata)meta).key = "NotCompatibleVersion";
        ((RuleMetadata)meta).name = "Incompatible versions: Your version of PVS-Studio is higher than the version of PVS-Studio plugin";
        ((RuleMetadata)meta).htmlDescription = "Incompatible versions: Your version of PVS-Studio is higher than the version of PVS-Studio plugin for sonarqube. Please update the plugin to the current version of PVS-Studio. This may cause issue loss and other errors.";
        ((RuleMetadata)meta).tags = new String[]{"bug", "pvs-studio", "pvs-studio#info"};
        ((RuleMetadata)meta).type = "BUG";
        this.tryAddRule(repo, meta, isVulnerability);
    }

    public static class RuleMetadata {
        public String key = null;
        public String severity = null;
        public String name = null;
        public String type = null;
        public String htmlDescription = null;
        public String[] tags = new String[0];
        public SecurityStandards securityStandards = new SecurityStandards();

        public static class SecurityStandards {
            public int[] CWE = new int[0];
            public OwaspTop10Mapping[] OWASP = new OwaspTop10Mapping[0];
        }

        public static class OwaspTop10Mapping {
            public String code = null;
            public int year;
        }
    }
}

