/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pvsstudio.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class ConfigReader<T> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    @NotNull
    private final Path path;
    @NotNull
    private final Class<T> configClass;

    public ConfigReader(@NotNull Path path, @NotNull Class<T> configClass) {
        this.path = path;
        this.configClass = configClass;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void write(T value) throws IOException {
        Utils.createDirectoriesToFile(this.path.toFile());
        try (RandomAccessFile raf = new RandomAccessFile(this.path.toFile(), "rw");){
            FileChannel channel = raf.getChannel();
            FileLock ignore = channel.lock();
            try (BufferedWriter buffWriter = new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(channel), StandardCharsets.UTF_8));){
                channel.truncate(0L);
                DEFAULT_GSON.toJson(value, (Appendable)buffWriter);
            }
        }
    }

    @NotNull
    public T read() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.path.toFile(), "r");){
            Object object;
            FileChannel channel = raf.getChannel();
            FileLock ignore = channel.lock(0L, Long.MAX_VALUE, true);
            try (BufferedReader buffReader = new BufferedReader(new InputStreamReader(Channels.newInputStream(channel), StandardCharsets.UTF_8));){
                Object config = DEFAULT_GSON.fromJson((Reader)buffReader, this.configClass);
                if (config == null) {
                    throw new InvalidFormatException("Invalid config at " + this.path);
                }
                object = config;
            }
            return (T)object;
        }
    }

    public static class InvalidFormatException
    extends IOException {
        public InvalidFormatException(String message) {
            super(message);
        }
    }
}

