/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.config;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.config.JavaConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ConfigMerger {
    private final List<JavaConfig> sources;
    private MutableBoolean isDirty;

    private ConfigMerger(JavaConfig ... sources) {
        this.sources = Arrays.asList(sources);
    }

    public static ConfigMerger merger(JavaConfig ... sources) {
        return new ConfigMerger(sources);
    }

    public ConfigMerger dirtyMarker(MutableBoolean holder) {
        this.isDirty = holder;
        return this;
    }

    public void merge(JavaConfig target) {
        boolean dirty = false;
        for (JavaConfig from : this.sources) {
            dirty |= this.mergeConfig(target, from);
        }
        if (this.isDirty != null && dirty) {
            this.isDirty.setTrue();
        }
    }

    private boolean mergeConfig(JavaConfig target, JavaConfig source) {
        boolean markDirty = false;
        try {
            for (Field targetField : ConfigMerger.getNonStaticFields(target.getClass())) {
                targetField.setAccessible(true);
                String fieldName = targetField.getName();
                Field sourceField = ConfigMerger.getField(source.getClass(), fieldName);
                if (sourceField == null) continue;
                sourceField.setAccessible(true);
                Object targetValue = targetField.get(target);
                Object sourceValue = sourceField.get(source);
                if (targetValue != null || sourceValue == null) continue;
                targetField.set(target, sourceValue);
                markDirty = true;
            }
        }
        catch (IllegalAccessException ex) {
            throw new PvsStudioException("Failed to merge configurations", ex);
        }
        return markDirty;
    }

    private static Field[] getNonStaticFields(Class<?> clazz) {
        return (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
    }

    @Nullable
    private static Field getField(Class<?> clazz, String fieldName) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

