/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.android;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.android.classpath.ClasspathResolver;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;

public class AndroidProjectResolver {
    private final Project project;

    public AndroidProjectResolver(Project project) {
        this.project = project;
    }

    public Set<File> resolveSources() throws ReflectiveOperationException {
        Object android = this.project.property("android");
        if (android == null) {
            throw new PvsStudioException("Android plugin not found.");
        }
        Method methodGetSourceSets = android.getClass().getDeclaredMethod("getSourceSets", new Class[0]);
        methodGetSourceSets.setAccessible(true);
        HashSet<File> sources = new HashSet<File>();
        Object container = methodGetSourceSets.invoke(android, new Object[0]);
        if (container instanceof NamedDomainObjectContainer) {
            NamedDomainObjectContainer factory = (NamedDomainObjectContainer)container;
            for (String name : factory.getNames()) {
                Set tmpSet;
                Object androidSourceSets = factory.getAt(name);
                Method methodGetJavaDirs = androidSourceSets.getClass().getDeclaredMethod("getJavaDirectories", new Class[0]);
                methodGetJavaDirs.setAccessible(true);
                Object set = methodGetJavaDirs.invoke(androidSourceSets, new Object[0]);
                if (!(set instanceof Set) || (tmpSet = (Set)set).isEmpty() || !(tmpSet.iterator().next() instanceof File)) continue;
                sources.addAll((Set)set);
            }
        }
        return sources;
    }

    public Set<File> resolveClasspath() throws ReflectiveOperationException {
        ClasspathResolver impl = AndroidProjectResolver.createClasspathResolver();
        return impl.resolve(this.project);
    }

    private static ClasspathResolver createClasspathResolver() throws ReflectiveOperationException {
        String className = GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) >= 0 ? "com.pvsstudio.android.classpath.ClasspathResolver4" : "com.pvsstudio.android.classpath.ClasspathResolver3";
        Class<?> clazz = Class.forName(className);
        return (ClasspathResolver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

