/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsOSUtils;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import com.pvsstudio.Version;
import com.pvsstudio.util.PvsVersionComparator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PvsStudioDownloader {
    private static File getLocalZipFile() {
        return new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, Version.getActualVersion() + ".zip");
    }

    private static String getRemotePathRelease() {
        return String.format("%s/%s.zip", "http://files.pvs-studio.com/java/pvsstudio-cores", Version.getActualVersion());
    }

    private static String getRemotePathBeta() {
        return String.format("%s/%s.zip", "http://files.pvs-studio.com/java/beta/pvsstudio-cores", Version.getActualVersion());
    }

    private PvsStudioDownloader() {
    }

    private static void initializeProxyAuthenticator(final @NotNull String protocol, final @NotNull Proxy proxy) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            @Nullable
            public PasswordAuthentication getPasswordAuthentication() {
                String proxyHost = "";
                int proxyPort = -1;
                if (proxy.address() instanceof InetSocketAddress) {
                    proxyHost = ((InetSocketAddress)proxy.address()).getHostName();
                    proxyPort = ((InetSocketAddress)proxy.address()).getPort();
                }
                String currentHost = this.getRequestingHost();
                int currentPort = this.getRequestingPort();
                if (proxyHost != null && proxyHost.equalsIgnoreCase(currentHost) && proxyPort == currentPort) {
                    String proxyPass;
                    String proxyUser = !protocol.equals("socks") ? System.getProperty(protocol + ".proxyUser") : System.getProperty("java.net.socks.username");
                    String string = proxyPass = !protocol.equals("socks") ? System.getProperty(protocol + ".proxyPassword") : System.getProperty("java.net.socks.password");
                    if (proxyUser != null && proxyPass != null) {
                        return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    private static Proxy getSystemProxy() {
        List<Proxy> proxies;
        try {
            ProxySelector defaultProxy = ProxySelector.getDefault();
            proxies = defaultProxy.select(new URI("http://files.pvs-studio.com/java/pvsstudio-cores"));
        }
        catch (Exception e) {
            return Proxy.NO_PROXY;
        }
        if (proxies != null && !proxies.isEmpty()) {
            return proxies.get(0);
        }
        return Proxy.NO_PROXY;
    }

    @Nullable
    private static String getHighestLocalCoreReleaseVersion() {
        String string;
        block8: {
            String currentVersionMajorMinor = "7.39.100930".substring(0, "7.39.100930".lastIndexOf(46));
            Path javaDirectory = Paths.get(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, new String[0]);
            Stream<Path> files = Files.list(javaDirectory);
            try {
                string = files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !Files.exists(path.resolve("beta"), new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(version -> version.startsWith(currentVersionMajorMinor)).filter(PvsStudioDownloader::isCorrectVersion).max(PvsVersionComparator.MAJOR_MINOR_REVISION).orElse(null);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PvsStudioException("Could not find the highest core version", e);
                }
            }
            files.close();
        }
        return string;
    }

    private static boolean isCorrectVersion(String version) {
        String[] split = version.split("\\.");
        if (split.length != 3) {
            return false;
        }
        try {
            Integer.parseInt(split[0]);
            Integer.parseInt(split[1]);
            Integer.parseInt(split[2]);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isCurrentVersionIsBeta() {
        try {
            MutableInt responseCode = new MutableInt(-1);
            PvsStudioDownloader.tryExecuteAction(proxy -> {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    HttpURLConnection connection = (HttpURLConnection)new URL(PvsStudioDownloader.getRemotePathBeta()).openConnection((Proxy)proxy);
                    connection.setReadTimeout(1000);
                    connection.setConnectTimeout(1000);
                    connection.setRequestMethod("HEAD");
                    int code = connection.getResponseCode();
                    if (code == 200 || code == 404) {
                        responseCode.setValue(code);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
            if (responseCode.getValue().equals(200)) {
                return true;
            }
        }
        catch (PvsStudioException pvsStudioException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean coreExists() {
        if (new File(Utils.absolutePath(AnalyzerConfig.PVS_JAVA_ANALYZER_CORE_DIRECTORY, "beta")).exists() || Version.isDevelopment() || PvsStudioDownloader.isCurrentVersionIsBeta()) return new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, Version.getActualVersion()).exists();
        PvsStudioException initLatestVersionExeption = null;
        String latestVersion = "";
        try {
            latestVersion = Version.getLatestVersion();
        }
        catch (PvsStudioException ex) {
            initLatestVersionExeption = ex;
        }
        String highestLocalReleaseCoreVersion = PvsStudioDownloader.getHighestLocalCoreReleaseVersion();
        PvsVersionComparator comparatorMajorMinorRevision = PvsVersionComparator.MAJOR_MINOR_REVISION;
        PvsVersionComparator comparatorMajorMinor = PvsVersionComparator.MAJOR_MINOR;
        if (initLatestVersionExeption != null) {
            if (highestLocalReleaseCoreVersion == null) {
                Version.setActualVersion("7.39.100930");
            } else {
                if (comparatorMajorMinorRevision.compare(highestLocalReleaseCoreVersion, "7.39.100930") < 0) throw initLatestVersionExeption;
                Version.setActualVersion(highestLocalReleaseCoreVersion);
            }
        } else {
            String currentVersionMajorMinor;
            if (latestVersion.isEmpty()) throw new PvsStudioException("Unknown version! Latest version is empty!");
            String latestVersionMajorMinor = latestVersion.substring(0, latestVersion.lastIndexOf(46));
            if (comparatorMajorMinor.compare(latestVersionMajorMinor, currentVersionMajorMinor = "7.39.100930".substring(0, "7.39.100930".lastIndexOf(46))) == 0) {
                if (comparatorMajorMinorRevision.compare(latestVersion, "7.39.100930") >= 0) {
                    Version.setActualVersion(latestVersion);
                } else {
                    Version.setActualVersion("7.39.100930");
                }
            } else if (highestLocalReleaseCoreVersion == null || comparatorMajorMinorRevision.compare(highestLocalReleaseCoreVersion, "7.39.100930") < 0) {
                Version.setActualVersion("7.39.100930");
            } else {
                Version.setActualVersion(highestLocalReleaseCoreVersion);
            }
        }
        AnalyzerConfig.updateAnalyzerVersion(Version.getActualVersion());
        return new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, Version.getActualVersion()).exists();
    }

    private static boolean doDownload(@NotNull URL url, @NotNull File file, @NotNull Proxy proxy) throws IOException {
        URLConnection connection = url.openConnection(proxy);
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
             InputStream inputStream = connection.getInputStream();){
            int len;
            byte[] buffer = new byte[10240];
            while ((len = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
        }
        catch (Exception ex) {
            FileUtils.deleteQuietly((File)file);
            throw ex;
        }
        return file.exists();
    }

    private static boolean downloadCore(@NotNull Proxy proxy) {
        try {
            if (PvsStudioDownloader.doDownload(new URL(PvsStudioDownloader.getRemotePathRelease()), PvsStudioDownloader.getLocalZipFile(), proxy)) {
                return true;
            }
        }
        catch (IOException ex1) {
            try {
                if (PvsStudioDownloader.doDownload(new URL(PvsStudioDownloader.getRemotePathBeta()), PvsStudioDownloader.getLocalZipFile(), proxy)) {
                    Version.setBeta(true);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new PvsStudioException(ex1.getMessage());
        }
        return false;
    }

    static void tryExecuteAction(Function<Proxy, Boolean> executor) {
        StringBuilder messageException;
        block14: {
            if (!new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).exists() && !new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).mkdirs()) {
                throw new PvsStudioException("Unable to create directory: " + AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY);
            }
            messageException = new StringBuilder("Unable to download PVS-Studio Java analyzer core.");
            try {
                if (executor.apply(Proxy.NO_PROXY).booleanValue()) {
                    return;
                }
            }
            catch (Exception ex) {
                messageException.append("\nDirect download failed: ");
                messageException.append(ex.getMessage());
                if (messageException.toString().endsWith(".")) break block14;
                messageException.append('.');
            }
        }
        String[] protocols = new String[]{"http", "https", "ftp"};
        HashMap<String, String> map = new HashMap<String, String>();
        for (String protocol : protocols) {
            String host = System.getProperty(protocol + ".proxyHost");
            String port = System.getProperty(protocol + ".proxyPort");
            if (host == null || port == null) continue;
            map.put(protocol, String.format("%s:%s", host, port));
        }
        if (System.getProperty("socksProxyHost") != null && System.getProperty("socksProxyPort") != null) {
            map.put("socks", String.format("%s:%s", System.getProperty("socksProxyHost"), System.getProperty("socksProxyPort")));
        }
        HashMap<String, Proxy> listAvailableProxies = new HashMap<String, Proxy>();
        for (Map.Entry entry : map.entrySet()) {
            String[] hostport = ((String)entry.getValue()).split(":");
            if (hostport.length != 2) continue;
            listAvailableProxies.put((String)entry.getKey(), new Proxy(!((String)entry.getKey()).equals("socks") ? Proxy.Type.HTTP : Proxy.Type.SOCKS, new InetSocketAddress(hostport[0], Integer.parseInt(hostport[1]))));
        }
        for (Map.Entry entry : listAvailableProxies.entrySet()) {
            try {
                PvsStudioDownloader.initializeProxyAuthenticator((String)entry.getKey(), (Proxy)entry.getValue());
                if (!executor.apply((Proxy)entry.getValue()).booleanValue()) continue;
                return;
            }
            catch (Exception ex) {
                messageException.append("\nDownload through ");
                InetSocketAddress address = (InetSocketAddress)((Proxy)entry.getValue()).address();
                messageException.append(String.format("%s @ %s:%s", ((String)entry.getKey()).toUpperCase(), address.getHostName(), address.getPort()));
                messageException.append(" failed: ");
                messageException.append(ex.getMessage());
                if (messageException.toString().endsWith(".")) continue;
                messageException.append('.');
            }
        }
        System.setProperty("java.net.useSystemProxies", "true");
        Proxy proxy = PvsStudioDownloader.getSystemProxy();
        if (proxy != Proxy.NO_PROXY && proxy.type() != Proxy.Type.DIRECT) {
            try {
                PvsStudioDownloader.initializeProxyAuthenticator(proxy.type() == Proxy.Type.HTTP ? "http" : "socks", proxy);
                if (executor.apply(proxy).booleanValue()) {
                    return;
                }
            }
            catch (Exception ex) {
                messageException.append("\nDownload through ");
                messageException.append(proxy);
                messageException.append(" failed: ");
                messageException.append(ex.getMessage());
            }
        }
        System.setProperty("java.net.useSystemProxies", "false");
        messageException.append("\nIf you use proxy, you should specify proxy credentials (user and password, for example, -Dhttp.proxyUser, -Dhttp.proxyPassword) to enable the analyzer to download and update its core.");
        throw new PvsStudioException(messageException.toString());
    }

    private static boolean isNewer(String version1, String version2) {
        return PvsVersionComparator.MAJOR_MINOR_REVISION.compare(version1, version2) > 0;
    }

    private static void deleteOldCores() {
        File[] directories = new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).listFiles(File::isDirectory);
        if (directories != null) {
            for (File d : directories) {
                if (d.getName().equals("0.0.0") || !PvsStudioDownloader.isCorrectVersion(d.getName()) || !PvsStudioDownloader.isNewer(Version.getActualVersion(), d.getName())) continue;
                try {
                    FileUtils.deleteDirectory((File)d);
                }
                catch (IOException e) {
                    throw new PvsStudioException("Unable to remove old installation: " + d.getName(), e);
                }
            }
        }
    }

    private static void installCore() {
        try (ZipFile zipFile = new ZipFile(PvsStudioDownloader.getLocalZipFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new PvsStudioException("Unable to unzip PVS-Studio Core.", e);
        }
        FileUtils.deleteQuietly((File)PvsStudioDownloader.getLocalZipFile());
        if (Version.isBeta()) {
            try {
                new File(Utils.absolutePath(AnalyzerConfig.PVS_JAVA_ANALYZER_CORE_DIRECTORY, "beta")).createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PvsStudioDownloader.deleteOldCores();
    }

    private static void unpackDocumentation() {
        File newDocumentationDirectory = new File(Utils.absolutePath(AnalyzerConfig.PVS_JAVA_ANALYZER_CORE_DIRECTORY, "Documentation"));
        if (!newDocumentationDirectory.exists()) {
            return;
        }
        File documentationDirectory = new File(Utils.absolutePath(System.getProperty("user.home"), "usr/share/docs/pvs-studio"), "Documentation");
        if (!documentationDirectory.exists()) {
            documentationDirectory.mkdirs();
        } else {
            File oldDocumentationDirectory = new File(Utils.absolutePath(documentationDirectory.toString(), "Documentation"));
            if (oldDocumentationDirectory.exists()) {
                try {
                    FileUtils.deleteDirectory((File)oldDocumentationDirectory);
                }
                catch (IOException e) {
                    return;
                }
            }
        }
        try {
            FileUtils.copyDirectory((File)newDocumentationDirectory, (File)documentationDirectory);
        }
        catch (IOException e) {
            System.out.println("Unable to save documentation");
        }
    }

    public static void initCore() {
        if (!PvsStudioDownloader.coreExists()) {
            System.out.printf("Downloading PVS-Studio Core v%s...%n", Version.getActualVersion());
            PvsStudioDownloader.tryExecuteAction(PvsStudioDownloader::downloadCore);
            System.out.printf("Unzipping PVS-Studio Core v%s...%n", Version.getActualVersion());
            PvsStudioDownloader.installCore();
        }
        if (PvsOSUtils.isUnix()) {
            PvsStudioDownloader.unpackDocumentation();
        }
    }
}

