/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import org.jetbrains.annotations.NotNull;

public final class PvsOSUtils {
    @NotNull
    private static final String ArchValidator = System.getProperty("os.arch").toLowerCase();
    @NotNull
    private static final String OSValidator = System.getProperty("os.name").toLowerCase();
    public static final String WINDOWS_ARM_MESSAGE_FOR_PVS_JAR = "The PVS-Studio Java analyzer core does not support the ARM JDK on Windows. Please use the x64 JDK to run the Java analyzer core. Please contact us at 'https://pvs-studio.com/en/about-feedback/' if you are interested in PVS-Studio support for ARM JDK on Windows.";
    public static final String MAC_OS_ARM_MESSAGE_FOR_PVS_JAR = "Analysis on Apple ARM processors is not supported. Please contact us at 'https://pvs-studio.com/en/about-feedback/' if you are interested in PVS-Studio support for these platforms.";

    private PvsOSUtils() {
    }

    public static boolean isWindows() {
        return OSValidator.contains("win");
    }

    public static boolean isMac() {
        return OSValidator.contains("mac");
    }

    public static boolean isUnix() {
        return OSValidator.contains("nix") || OSValidator.contains("nux") || OSValidator.contains("aix") || OSValidator.contains("solaris") || OSValidator.contains("sunos");
    }

    public static boolean isWindowsArm() {
        return PvsOSUtils.isWindows() && (ArchValidator.contains("aarch64") || ArchValidator.contains("arm64"));
    }

    public static boolean isMacArm() {
        return PvsOSUtils.isMac() && (ArchValidator.contains("aarch64") || ArchValidator.contains("arm64"));
    }
}

