/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.JsonProject;
import com.pvsstudio.MavenGradlePluginTask;
import com.pvsstudio.PvsJavaPluginConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.PvsStudioInvoker;
import org.gradle.api.DefaultTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PvsGradleTask
extends DefaultTask
implements MavenGradlePluginTask {
    @Override
    @NotNull
    public String projectRootFolder() {
        return this.getProject().getRootDir().getAbsolutePath();
    }

    @Override
    @NotNull
    public PvsJavaPluginConfig.Plugin pluginType() {
        return PvsJavaPluginConfig.Plugin.GRADLE;
    }

    @Override
    @Nullable
    public PvsStudioException taskException(@Nullable PvsStudioException pvsStudioException) {
        if (pvsStudioException == null) {
            return null;
        }
        return new PvsStudioException(this.taskFailedMessage(), pvsStudioException);
    }

    public final void executeTask() {
        PvsStudioException taskException;
        try {
            this.initJavaAnalyzerCore();
            JsonProject jsonProject = this.jsonProject();
            PvsJavaPluginConfig pluginConfig = this.pvsJavaPluginConfig(this.projectFolderAbsolutePath(), this.pluginType(), this.configFromProperties(), this.configFromBuildSystemScript(), this.globalConfig());
            taskException = this.executeTaskAndGetException(pluginConfig, jsonProject);
        }
        catch (Exception ex) {
            taskException = new PvsStudioException(this.taskFailedMessage(), ex);
        }
        if (taskException != null) {
            this.printExampleMessageAndSetTaskException(taskException);
        }
    }

    @Override
    @Nullable
    public PvsStudioException executeTaskAndGetException(@NotNull PvsJavaPluginConfig pluginConfig, @NotNull JsonProject jsonProject) {
        int javaCoreReturnCode = PvsStudioInvoker.runAnalyzerCoreProcess(System.out::println, pluginConfig, jsonProject);
        PvsStudioException taskException = javaCoreReturnCode != 0 ? this.taskException(this.pvsStudioExceptionForRunAnalyzerProcessFromMavenOrGradlePlugins(javaCoreReturnCode, pluginConfig)) : null;
        return taskException;
    }

    protected void printExampleMessageAndSetTaskException(@NotNull PvsStudioException taskException) {
        this.printExampleMessage();
        this.getState().setOutcome((RuntimeException)taskException);
    }
}

