/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.JavaVersion;
import com.pvsstudio.PvsStudioException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class JdkRuntimeUtils {
    public static final int JAVA_CORE_MINIMUM_SUPPORTED_VERSION = 11;
    public static final int SPOON_MAXIMUM_COMPLIANCE_LEVEL = 21;
    private static final JavaVersion JAVA_SPECIFICATION_VERSION;
    private static final boolean IS_JAVA_21;
    private static final boolean IS_JAVA_20;
    private static final boolean IS_JAVA_19;
    private static final boolean IS_JAVA_18;
    private static final boolean IS_JAVA_17;
    private static final boolean IS_JAVA_16;
    private static final boolean IS_JAVA_15;
    private static final boolean IS_JAVA_14;
    private static final boolean IS_JAVA_13;
    private static final boolean IS_JAVA_12;
    private static final boolean IS_JAVA_11;

    private static String getJavaSpecificationVersion() {
        try {
            return System.getProperty("java.specification.version");
        }
        catch (SecurityException var2) {
            return null;
        }
    }

    public static boolean isJavaVersionAtLeast(JavaVersion required) {
        return JAVA_SPECIFICATION_VERSION.atLeast(required);
    }

    public static boolean isJavaVersionAtMost(JavaVersion required) {
        return JAVA_SPECIFICATION_VERSION.atMost(required);
    }

    private static boolean getJavaVersionMatches(String versionPrefix) {
        return JdkRuntimeUtils.isJavaVersionMatch(versionPrefix);
    }

    private static boolean isJavaVersionMatch(String versionPrefix) {
        return JAVA_SPECIFICATION_VERSION != null && JAVA_SPECIFICATION_VERSION.toString().startsWith(versionPrefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJavaVersionForJavaPath(String javaPath) {
        try {
            Process getJavaVersionProcess = new ProcessBuilder(javaPath, "-XshowSettings:properties", "-version").redirectErrorStream(true).start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(getJavaVersionProcess.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (!line.contains("java.specification.version")) continue;
                    String string = line.substring(line.indexOf("=") + 1).trim();
                    return string;
                }
            }
            getJavaVersionProcess.waitFor();
            return JAVA_SPECIFICATION_VERSION.toString();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getNewComplianceLevel() {
        if (!JdkRuntimeUtils.isJavaVersionAtMost(JavaVersion.get(String.valueOf(21)))) {
            return 21;
        }
        try {
            return Integer.parseInt(JAVA_SPECIFICATION_VERSION.toString());
        }
        catch (NumberFormatException e) {
            throw new PvsStudioException("Only Java version 11 or higher is supported", e);
        }
    }

    @Deprecated
    public static int getComplianceLevel() {
        int complianceLevel = IS_JAVA_21 ? 21 : (IS_JAVA_20 ? 20 : (IS_JAVA_19 ? 19 : (IS_JAVA_18 ? 18 : (IS_JAVA_17 ? 17 : (IS_JAVA_16 ? 16 : (IS_JAVA_15 ? 15 : (IS_JAVA_14 ? 14 : (IS_JAVA_13 ? 13 : (IS_JAVA_12 ? 12 : (IS_JAVA_11 ? 11 : 21))))))))));
        return complianceLevel;
    }

    static {
        String javaSpecificationVersion = JdkRuntimeUtils.getJavaSpecificationVersion();
        if (javaSpecificationVersion == null) {
            throw new RuntimeException("Couldn't get the current Java Runtime version");
        }
        JAVA_SPECIFICATION_VERSION = JavaVersion.get(javaSpecificationVersion);
        IS_JAVA_21 = JdkRuntimeUtils.getJavaVersionMatches(Integer.toString(21));
        IS_JAVA_20 = JdkRuntimeUtils.getJavaVersionMatches("20");
        IS_JAVA_19 = JdkRuntimeUtils.getJavaVersionMatches("19");
        IS_JAVA_18 = JdkRuntimeUtils.getJavaVersionMatches("18");
        IS_JAVA_17 = JdkRuntimeUtils.getJavaVersionMatches("17");
        IS_JAVA_16 = JdkRuntimeUtils.getJavaVersionMatches("16");
        IS_JAVA_15 = JdkRuntimeUtils.getJavaVersionMatches("15");
        IS_JAVA_14 = JdkRuntimeUtils.getJavaVersionMatches("14");
        IS_JAVA_13 = JdkRuntimeUtils.getJavaVersionMatches("13");
        IS_JAVA_12 = JdkRuntimeUtils.getJavaVersionMatches("12");
        IS_JAVA_11 = JdkRuntimeUtils.getJavaVersionMatches("11");
    }
}

