/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util;

import com.pvsstudio.PvsStudioException;
import java.util.Comparator;

public class PvsVersionComparator
implements Comparator<String> {
    public final int versionComponentsCount;
    public static final PvsVersionComparator MAJOR_MINOR_REVISION = new PvsVersionComparator(3);
    public static final PvsVersionComparator MAJOR_MINOR = new PvsVersionComparator(2);

    private PvsVersionComparator(int versionComponentsCount) {
        this.versionComponentsCount = versionComponentsCount;
    }

    @Override
    public int compare(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        String[] split1 = version1.split("\\.");
        String[] split2 = version2.split("\\.");
        if (split1.length != this.versionComponentsCount || split2.length != this.versionComponentsCount) {
            throw new PvsStudioException(String.format("Invalid version format for compare. Left: %s, Right: %s Expected version components count: %d", version1, version2, this.versionComponentsCount));
        }
        for (int i = 0; i < this.versionComponentsCount; ++i) {
            int componentVersion2;
            int componentVersion1 = Integer.parseInt(split1[i]);
            int componentsCompareResult = Integer.compare(componentVersion1, componentVersion2 = Integer.parseInt(split2[i]));
            if (componentsCompareResult == 0) continue;
            return componentsCompareResult;
        }
        return 0;
    }
}

