/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.timeout;

import com.pvsstudio.timeout.TimeoutChecker;
import com.pvsstudio.timeout.TimeoutCheckerFactory;
import java.time.Duration;
import java.util.function.Supplier;

public class DefaultTimeoutCheckerFactory
implements TimeoutCheckerFactory {
    private final long timeoutMillis;

    public DefaultTimeoutCheckerFactory(Duration timeout) {
        this.timeoutMillis = timeout.toMillis();
    }

    @Override
    public TimeoutChecker timeoutCheckerWithCurrentTimestamp() {
        return new DefaultTimeoutChecker(System.currentTimeMillis() + this.timeoutMillis);
    }

    private static final class DefaultTimeoutChecker
    implements TimeoutChecker {
        private final long timeoutEndMillis;

        public DefaultTimeoutChecker(long timeoutEndMillis) {
            this.timeoutEndMillis = timeoutEndMillis;
        }

        @Override
        public <X extends Throwable> void assertNotTimeout(Supplier<X> throwableSupplier) throws X {
            if (System.currentTimeMillis() >= this.timeoutEndMillis) {
                throw (Throwable)throwableSupplier.get();
            }
        }
    }
}

