/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.config;

import com.google.gson.JsonParseException;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.GlobalConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.config.ConfigMerger;
import com.pvsstudio.config.ConfigReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class GlobalConfigService {
    private final ConfigReader<GlobalConfig> configReader;
    public final GlobalConfig globalConfig;

    public GlobalConfigService(String path) {
        this(Paths.get(path, new String[0]));
    }

    public GlobalConfigService(Path path) {
        this.configReader = new ConfigReader<GlobalConfig>(path, GlobalConfig.class);
        if (this.configReader.exists()) {
            GlobalConfig temp;
            try {
                temp = this.configReader.read();
            }
            catch (ConfigReader.InvalidFormatException ex) {
                temp = new GlobalConfig();
            }
            catch (IOException ex) {
                throw new PvsStudioException("Error reading global.json", ex);
            }
            this.globalConfig = temp;
        } else {
            this.globalConfig = new GlobalConfig();
        }
    }

    public boolean syncWithLocal(AnalyzerConfig localConfig) {
        MutableBoolean isDirty = new MutableBoolean();
        ConfigMerger.merger(this.globalConfig).dirtyMarker(isDirty).merge(localConfig);
        ConfigMerger.merger(localConfig).dirtyMarker(isDirty).merge(this.globalConfig);
        return isDirty.booleanValue();
    }

    public void save() throws IOException, JsonParseException {
        this.configReader.write(this.globalConfig);
    }

    public AnalyzerConfig getAsAnalyzerConfig() {
        AnalyzerConfig config = AnalyzerConfig.blankConfig();
        ConfigMerger.merger(this.globalConfig).merge(config);
        return config;
    }
}

