/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioLicenseException;
import com.pvsstudio.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class LicenseFileInfo {
    @NotNull
    public static final LicenseFileInfo EMPTY = new LicenseFileInfo("", "");
    @NotNull
    private final String userName;
    @NotNull
    private final String licenseKey;

    private LicenseFileInfo(@NotNull String userName, @NotNull String licenseKey) {
        this.userName = userName;
        this.licenseKey = licenseKey;
    }

    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @NotNull
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @NotNull
    public static LicenseFileInfo readFrom(@NotNull String path) throws IOException, ParserConfigurationException, SAXException {
        return new File(path).exists() ? LicenseFileInfo.readLicenseFile(path) : EMPTY;
    }

    @NotNull
    public static LicenseFileInfo readFromStandardPath() throws IOException, ParserConfigurationException, SAXException {
        LicenseFileInfo result = EMPTY;
        if (new File(AnalyzerConfig.PVS_LICENSE_FILE).exists()) {
            result = LicenseFileInfo.readFrom(AnalyzerConfig.PVS_LICENSE_FILE);
        } else if (new File(AnalyzerConfig.PVS_JAVA_LICENSE_FILE).exists()) {
            result = LicenseFileInfo.readFrom(AnalyzerConfig.PVS_JAVA_LICENSE_FILE);
        }
        return result;
    }

    @NotNull
    private static LicenseFileInfo readLicenseFile(@NotNull String path) throws PvsStudioLicenseException, IOException, ParserConfigurationException, SAXException {
        LicenseFileInfo result;
        if (path.endsWith(".xml")) {
            String licenseInfo = Utils.getLicenseInfoFromSettingsXml(path);
            String[] split = licenseInfo.split(System.lineSeparator());
            result = split.length == 2 ? new LicenseFileInfo(split[0] != null ? split[0] : "", split[1] != null ? split[1] : "") : EMPTY;
        } else if (path.endsWith(".lic")) {
            List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
            if (lines.size() != 2) {
                throw new PvsStudioLicenseException(String.format("Expected 2 lines in the .lic file, got %d. The file might be corrupted", lines.size()));
            }
            result = new LicenseFileInfo(lines.get(0).replaceAll("\ufeff", "").trim(), lines.get(1).trim());
        } else {
            throw new PvsStudioLicenseException("Unknown extension for license file: " + path);
        }
        return result;
    }
}

