/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.utility;

import java.util.List;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class InvocationWrapper {
    private final String invSimpleName;
    private final String returnQualifiedName;
    private final List<String> paramsTypeQualifiedNames;
    private final String classQualifiedName;

    public InvocationWrapper(String invSimpleName, String returnQualifiedName, List<String> paramsTypeQualifiedNames, String classSimpleName) {
        this.invSimpleName = invSimpleName;
        this.returnQualifiedName = returnQualifiedName;
        this.paramsTypeQualifiedNames = paramsTypeQualifiedNames;
        this.classQualifiedName = classSimpleName;
    }

    public boolean isSameInvocation(CtInvocation<?> inv) {
        CtExecutableReference exec = inv.getExecutable();
        if (!exec.getSimpleName().equals(this.invSimpleName)) {
            return false;
        }
        if (exec.getParameters().size() != this.paramsTypeQualifiedNames.size()) {
            return false;
        }
        for (int i = 0; i < this.paramsTypeQualifiedNames.size(); ++i) {
            if (((CtTypeReference)exec.getParameters().get(i)).getSimpleName().equals(this.paramsTypeQualifiedNames.get(i))) continue;
            return false;
        }
        if (exec.getType() == null) {
            return true;
        }
        return exec.getType().getQualifiedName().equals(this.returnQualifiedName);
    }

    public boolean isSameMethodNameAndClassName(CtInvocation<?> inv) {
        return (inv.getTarget().toString() + "." + inv.getExecutable().getSimpleName()).equals(this.classQualifiedName + "." + this.invSimpleName);
    }

    public boolean isSameInvocationName(CtInvocation<?> inv) {
        return inv.getExecutable().getSimpleName().equals(this.invSimpleName);
    }

    public boolean isSameInvocationWithClass(CtInvocation<?> inv) {
        CtExecutableReference exec = inv.getExecutable();
        if (!exec.getSimpleName().equals(this.invSimpleName)) {
            return false;
        }
        if (exec.getParameters().size() != this.paramsTypeQualifiedNames.size()) {
            return false;
        }
        if (!inv.getTarget().getType().getQualifiedName().equals(this.classQualifiedName)) {
            return false;
        }
        for (int i = 0; i < this.paramsTypeQualifiedNames.size(); ++i) {
            if (((CtTypeReference)exec.getParameters().get(i)).getSimpleName().equals(this.paramsTypeQualifiedNames.get(i))) continue;
            return false;
        }
        if (exec.getType() == null) {
            return true;
        }
        return exec.getType().getQualifiedName().equals(this.returnQualifiedName);
    }
}

