/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.traversal;

import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowNode;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.traverse.AbstractGraphIterator;

public class DFSAnyPath {
    private final Graph<ControlFlowNode, ControlFlowEdge> graph;
    private final ControlFlowNode startVertex;
    private final ControlFlowNode endVertex;

    public DFSAnyPath(Graph<ControlFlowNode, ControlFlowEdge> graph, ControlFlowNode startVertex, ControlFlowNode endVertex) {
        this.graph = graph;
        this.startVertex = startVertex;
        this.endVertex = endVertex;
    }

    public boolean hasPath() {
        SimpleDFSIterator iterator = new SimpleDFSIterator(this.graph, this.startVertex);
        while (iterator.hasNext()) {
            if (iterator.next() != this.endVertex) continue;
            return true;
        }
        return false;
    }

    private static class SimpleDFSIterator
    extends AbstractGraphIterator<ControlFlowNode, ControlFlowEdge> {
        private final Deque<ControlFlowNode> stack = new LinkedList<ControlFlowNode>();
        private final Set<ControlFlowNode> visited = Collections.newSetFromMap(new IdentityHashMap());

        private SimpleDFSIterator(Graph<ControlFlowNode, ControlFlowEdge> graph, ControlFlowNode startVertex) {
            super(graph);
            this.stack.push(startVertex);
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public ControlFlowNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more nodes to traverse.");
            }
            ControlFlowNode current = this.stack.pop();
            if (this.visited.add(current)) {
                for (ControlFlowEdge edge : this.graph.outgoingEdgesOf((Object)current)) {
                    ControlFlowNode neighbor = edge.getTargetNode();
                    if (this.visited.contains(neighbor)) continue;
                    this.stack.push(neighbor);
                }
            }
            return current;
        }
    }
}

