/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.traversal;

import com.pvsstudio.dataflow.graph.GraphModel;
import com.pvsstudio.dataflow.graph.GraphUtils;
import com.pvsstudio.dataflow.utility.InvocationWrapper;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.NodeKind;
import fr.inria.controlflow.NotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtVariableReference;

public class CFGMethodInvocationChecker {
    private final GraphModel graphModel;
    private final List<InvocationWrapper> invocationWrappers;
    private final List<InvocationWrapper> invocationsObjectsPass;

    public CFGMethodInvocationChecker(GraphModel graphModel, List<InvocationWrapper> invocationWrappers, List<InvocationWrapper> invWhereObjectPass) {
        this.graphModel = graphModel;
        this.invocationWrappers = invocationWrappers;
        this.invocationsObjectsPass = invWhereObjectPass;
    }

    public boolean methodCallsFromAllControlFlowPaths(CtMethod<?> method, CtStatement initStatement, CtVariableReference<?> initElem) {
        ControlFlowNode nextNode;
        ControlFlowNode node;
        ControlFlowGraph graph = this.graphModel.getControlGraph((CtExecutable<?>)method);
        if (graph == null) {
            return true;
        }
        try {
            node = graph.findNode((CtElement)initStatement);
        }
        catch (NotFoundException e) {
            return true;
        }
        HashSet refsToTargetObject = new HashSet();
        refsToTargetObject.add(initElem);
        List nextNodes = node.next();
        ControlFlowNode controlFlowNode = nextNode = nextNodes.size() == 1 ? (ControlFlowNode)nextNodes.get(0) : (ControlFlowNode)nextNodes.stream().filter(n -> n.getStatement() != null && !(n.getStatement() instanceof CtCatchVariable)).findFirst().orElse(null);
        if (nextNode == null) {
            return true;
        }
        EnumSet<TraverseState> result = this.traverseLinearControlFlowPath(nextNode, new HashSet<ControlFlowNode>(), refsToTargetObject);
        return !result.contains((Object)TraverseState.NO_CLOSE);
    }

    private EnumSet<TraverseState> traverseLinearControlFlowPath(ControlFlowNode startNode, Set<ControlFlowNode> visitedNodes, Set<CtVariableReference<?>> refsToTargetObject) {
        EnumSet<TraverseState> result = EnumSet.noneOf(TraverseState.class);
        ArrayDeque<ControlFlowNode> nextNodes = new ArrayDeque<ControlFlowNode>();
        nextNodes.add(startNode);
        while (!nextNodes.isEmpty()) {
            ControlFlowNode currentNode = (ControlFlowNode)nextNodes.pop();
            CtElement currentStatement = currentNode.getStatement();
            if (visitedNodes.contains(currentNode)) continue;
            if (currentNode.getKind() == NodeKind.EXIT) {
                if (!result.contains((Object)TraverseState.CLOSE)) {
                    result.add(TraverseState.NO_CLOSE);
                }
                return result;
            }
            if (currentStatement instanceof CtBinaryOperator && currentStatement.getParent() instanceof CtIf) {
                CtBinaryOperator binaryOp = (CtBinaryOperator)currentStatement;
                ControlFlowNode nextNode = this.getNonNullBranch(binaryOp, refsToTargetObject, currentNode);
                if (nextNode != null) {
                    result.addAll(this.traverseLinearControlFlowPath(nextNode, visitedNodes, new HashSet(refsToTargetObject)));
                    return result;
                }
            } else if (currentStatement instanceof CtInvocation) {
                TraverseState interProceduralResult;
                TraverseState invResult;
                CtInvocation invocation = (CtInvocation)currentStatement;
                if (this.isExitMethod(invocation)) {
                    result.add(TraverseState.CLOSE);
                    return result;
                }
                if (invocation.getTarget() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(invocation.getTarget())) && (invResult = this.handleInvocationOnObject(invocation)) == TraverseState.CLOSE) {
                    result.add(invResult);
                    return result;
                }
                List<Integer> numbersOfTargetParams = this.getParamIndexesOnTargetObject(invocation, refsToTargetObject);
                if (!numbersOfTargetParams.isEmpty() && (interProceduralResult = this.handleInterProcedural(invocation, numbersOfTargetParams)) == TraverseState.CLOSE) {
                    result.add(interProceduralResult);
                    return result;
                }
            } else {
                CtAssignment assignment;
                TraverseState assignmentResult;
                if (currentStatement instanceof CtReturn) {
                    CtReturn returnOp = (CtReturn)currentStatement;
                    TraverseState returnResult = this.handleReturnStatement(returnOp, refsToTargetObject);
                    if (returnResult == TraverseState.CLOSE) {
                        result.add(returnResult);
                    } else {
                        result.add(TraverseState.NO_CLOSE);
                    }
                    return result;
                }
                if (currentStatement instanceof CtLocalVariable) {
                    CtLocalVariable localVariable = (CtLocalVariable)currentStatement;
                    TraverseState localVariableResult = this.handleLocalVariable(localVariable, refsToTargetObject);
                    if (localVariableResult == TraverseState.CLOSE) {
                        result.add(localVariableResult);
                        return result;
                    }
                } else if (currentStatement instanceof CtAssignment && (assignmentResult = this.handleAssignment(assignment = (CtAssignment)currentStatement, refsToTargetObject, result)) != null) {
                    result.add(assignmentResult);
                    return result;
                }
            }
            visitedNodes.add(currentNode);
            List nodesFromCurrent = currentNode.next();
            if (nodesFromCurrent.size() > 1) {
                for (ControlFlowNode node : nodesFromCurrent) {
                    result.addAll(this.traverseLinearControlFlowPath(node, visitedNodes, new HashSet(refsToTargetObject)));
                }
                continue;
            }
            nextNodes.addAll(nodesFromCurrent);
        }
        return result;
    }

    private EnumSet<TraverseState> traverseThisInterProceduralControlFlowPath(ControlFlowNode startNode, Set<ControlFlowNode> visitedNodes) {
        EnumSet<TraverseState> result = EnumSet.noneOf(TraverseState.class);
        ArrayDeque<ControlFlowNode> nextNodes = new ArrayDeque<ControlFlowNode>();
        nextNodes.add(startNode);
        while (!nextNodes.isEmpty()) {
            CtInvocation invocation;
            ControlFlowNode currentNode = (ControlFlowNode)nextNodes.pop();
            CtElement currentStatement = currentNode.getStatement();
            if (visitedNodes.contains(currentNode)) continue;
            if (currentNode.getKind() == NodeKind.EXIT) {
                if (!result.contains((Object)TraverseState.CLOSE)) {
                    result.add(TraverseState.NO_CLOSE);
                }
                return result;
            }
            if (currentStatement instanceof CtInvocation && ((invocation = (CtInvocation)currentStatement).getTarget() instanceof CtThisAccess || invocation.getTarget() instanceof CtSuperAccess) && this.hasTargetInvocation(invocation)) {
                result.add(TraverseState.CLOSE);
                return result;
            }
            visitedNodes.add(currentNode);
            List nodesFromCurrent = currentNode.next();
            if (nodesFromCurrent.size() > 1) {
                for (ControlFlowNode node : nodesFromCurrent) {
                    result.addAll(this.traverseThisInterProceduralControlFlowPath(node, visitedNodes));
                }
                continue;
            }
            nextNodes.addAll(nodesFromCurrent);
        }
        return result;
    }

    private EnumSet<TraverseState> traverseParamInterProceduralControlFlowPath(ControlFlowNode startNode, Set<ControlFlowNode> visitedNodes, Set<CtVariableReference<?>> refsToTargetObject) {
        EnumSet<TraverseState> result = EnumSet.noneOf(TraverseState.class);
        ArrayDeque<ControlFlowNode> nextNodes = new ArrayDeque<ControlFlowNode>();
        nextNodes.add(startNode);
        while (!nextNodes.isEmpty()) {
            CtConstructorCall constructInvocation;
            CtLocalVariable localVariable;
            ControlFlowNode currentNode = (ControlFlowNode)nextNodes.pop();
            CtElement currentStatement = currentNode.getStatement();
            if (visitedNodes.contains(currentNode)) continue;
            if (currentNode.getKind() == NodeKind.EXIT) {
                if (!result.contains((Object)TraverseState.CLOSE)) {
                    result.add(TraverseState.NO_CLOSE);
                }
                return result;
            }
            if (currentStatement instanceof CtBinaryOperator && currentStatement.getParent() instanceof CtIf) {
                CtBinaryOperator binaryOp = (CtBinaryOperator)currentStatement;
                ControlFlowNode nextNode = this.getNonNullBranch(binaryOp, refsToTargetObject, currentNode);
                if (nextNode != null) {
                    result.addAll(this.traverseParamInterProceduralControlFlowPath(nextNode, visitedNodes, new HashSet(refsToTargetObject)));
                    return result;
                }
            } else if (currentStatement instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)currentStatement;
                if (invocation.getTarget() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(invocation.getTarget())) && this.hasTargetInvocation(invocation)) {
                    result.add(TraverseState.CLOSE);
                    return result;
                }
            } else if (currentStatement instanceof CtAssignment) {
                CtAssignment assignment = (CtAssignment)currentStatement;
                if (assignment.getAssignment() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(assignment.getAssignment())) && assignment.getAssigned() instanceof CtFieldWrite) {
                    result.add(TraverseState.CLOSE);
                    return result;
                }
                TraverseState assignmentResult = this.handleAssignment(assignment, refsToTargetObject, result);
                if (assignmentResult == TraverseState.CLOSE) {
                    result.add(TraverseState.CLOSE);
                    return result;
                }
            } else if (currentStatement instanceof CtLocalVariable && (localVariable = (CtLocalVariable)currentStatement).getAssignment() instanceof CtConstructorCall && this.objectPassedOnAnotherObject(constructInvocation = (CtConstructorCall)localVariable.getAssignment(), refsToTargetObject)) {
                result.add(TraverseState.CLOSE);
                return result;
            }
            visitedNodes.add(currentNode);
            List nodesFromCurrent = currentNode.next();
            if (nodesFromCurrent.size() > 1) {
                for (ControlFlowNode node : nodesFromCurrent) {
                    result.addAll(this.traverseParamInterProceduralControlFlowPath(node, visitedNodes, new HashSet(refsToTargetObject)));
                }
                continue;
            }
            nextNodes.addAll(nodesFromCurrent);
        }
        return result;
    }

    @Nullable
    private ControlFlowNode getNonNullBranch(CtBinaryOperator<?> binaryOp, Set<CtVariableReference<?>> refsToTargetObject, ControlFlowNode currentNode) {
        boolean isVarReadRight;
        ControlFlowNode nextNode = null;
        CtExpression lhs = binaryOp.getLeftHandOperand();
        CtExpression rhs = binaryOp.getRightHandOperand();
        boolean isNullLiteralLeft = lhs instanceof CtLiteral && ((CtLiteral)lhs).getValue() == null;
        boolean isNullLiteralRight = rhs instanceof CtLiteral && ((CtLiteral)rhs).getValue() == null;
        boolean isVarReadLeft = lhs instanceof CtVariableRead && refsToTargetObject.contains(((CtVariableRead)lhs).getVariable());
        boolean bl = isVarReadRight = rhs instanceof CtVariableRead && refsToTargetObject.contains(((CtVariableRead)rhs).getVariable());
        if (isVarReadLeft && isNullLiteralRight || isVarReadRight && isNullLiteralLeft) {
            BinaryOperatorKind binaryOperationKind = binaryOp.getKind();
            if (binaryOperationKind == BinaryOperatorKind.EQ) {
                nextNode = GraphUtils.getNodeFromElseBranch(currentNode);
            } else if (binaryOperationKind == BinaryOperatorKind.NE) {
                nextNode = GraphUtils.getNodeFromThenBranch(currentNode);
            }
        }
        return nextNode;
    }

    private boolean isExitMethod(CtInvocation<?> invocation) {
        return invocation.getExecutable().getSimpleName().equals("exit") && invocation.getExecutable().getDeclaringType().getQualifiedName().equals("java.lang.System");
    }

    private TraverseState handleInvocationOnObject(CtInvocation<?> invocation) {
        if (this.hasTargetInvocation(invocation)) {
            return TraverseState.CLOSE;
        }
        CtExecutable declaration = invocation.getExecutable().getExecutableDeclaration();
        if (declaration.getBody() != null && !declaration.getBody().getStatements().isEmpty()) {
            ControlFlowGraph cfg = this.graphModel.getControlGraph(declaration);
            if (cfg == null) {
                return TraverseState.CLOSE;
            }
            List nodes = cfg.findNodesOfKind(NodeKind.BEGIN);
            if (nodes.isEmpty()) {
                return TraverseState.CLOSE;
            }
            ControlFlowNode firstNode = (ControlFlowNode)nodes.get(0);
            EnumSet<TraverseState> thisInterProceduralResult = this.traverseThisInterProceduralControlFlowPath(firstNode, new HashSet<ControlFlowNode>());
            if (thisInterProceduralResult.size() == 1 && thisInterProceduralResult.contains((Object)TraverseState.CLOSE)) {
                return TraverseState.CLOSE;
            }
        }
        return null;
    }

    private List<Integer> getParamIndexesOnTargetObject(CtInvocation<?> invocation, Set<CtVariableReference<?>> refsToTargetObject) {
        ArrayList<Integer> numbersOfTargetParams = new ArrayList<Integer>();
        for (int i = 0; i < invocation.getArguments().size(); ++i) {
            if (!(invocation.getArguments().get(i) instanceof CtVariableAccess) || !refsToTargetObject.contains(this.getVariableFromExpression((CtExpression)invocation.getArguments().get(i)))) continue;
            numbersOfTargetParams.add(i);
        }
        return numbersOfTargetParams;
    }

    @Nullable
    private TraverseState handleInterProcedural(CtInvocation<?> invocation, List<Integer> numbersOfTargetParams) {
        if (this.hasSameSimpleName(invocation)) {
            return TraverseState.CLOSE;
        }
        CtExecutable method = invocation.getExecutable().getDeclaration();
        if (method instanceof CtMethod) {
            if (method.getParameters().size() != invocation.getArguments().size()) {
                return TraverseState.CLOSE;
            }
            ControlFlowGraph cfg = this.graphModel.getControlGraph(method);
            if (cfg == null) {
                return TraverseState.CLOSE;
            }
            List nodes = cfg.findNodesOfKind(NodeKind.BEGIN);
            if (nodes.isEmpty()) {
                return TraverseState.CLOSE;
            }
            ControlFlowNode firstNode = (ControlFlowNode)nodes.get(0);
            HashSet targetParams = new HashSet();
            for (int numberOfParam : numbersOfTargetParams) {
                targetParams.add((CtVariableReference<?>)((CtParameter)method.getParameters().get(numberOfParam)).getReference());
            }
            EnumSet<TraverseState> interProceduralResult = this.traverseParamInterProceduralControlFlowPath(firstNode, new HashSet<ControlFlowNode>(), targetParams);
            if (interProceduralResult.size() == 1 && interProceduralResult.contains((Object)TraverseState.CLOSE)) {
                return TraverseState.CLOSE;
            }
        }
        return null;
    }

    @Nullable
    private TraverseState handleReturnStatement(CtReturn<?> returnOp, Set<CtVariableReference<?>> refsToTargetObject) {
        CtConstructorCall constructInvocation;
        if (returnOp.getReturnedExpression() instanceof CtConstructorCall && this.objectPassedOnAnotherObject(constructInvocation = (CtConstructorCall)returnOp.getReturnedExpression(), refsToTargetObject)) {
            return TraverseState.CLOSE;
        }
        if (returnOp.getReturnedExpression() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(returnOp.getReturnedExpression()))) {
            return TraverseState.CLOSE;
        }
        return null;
    }

    @Nullable
    private TraverseState handleLocalVariable(CtLocalVariable<?> localVariable, Set<CtVariableReference<?>> refsToTargetObject) {
        CtConstructorCall constructInvocation;
        if (localVariable.getAssignment() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(localVariable.getAssignment()))) {
            refsToTargetObject.add((CtVariableReference<?>)localVariable.getReference());
        } else if (localVariable.getAssignment() instanceof CtConstructorCall && this.objectPassedOnAnotherObject(constructInvocation = (CtConstructorCall)localVariable.getAssignment(), refsToTargetObject)) {
            return TraverseState.CLOSE;
        }
        return null;
    }

    private TraverseState handleAssignment(CtAssignment<?, ?> assignment, Set<CtVariableReference<?>> refsToTargetObject, EnumSet<TraverseState> currentResult) {
        CtConstructorCall constructInvocation;
        if (assignment.getAssignment() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(assignment.getAssignment()))) {
            if (assignment.getAssigned() instanceof CtFieldWrite) {
                return TraverseState.CLOSE;
            }
            if (assignment.getAssigned() instanceof CtVariableAccess) {
                refsToTargetObject.add(this.getVariableFromExpression(assignment.getAssigned()));
            }
        } else if (assignment.getAssigned() instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(assignment.getAssigned()))) {
            if (assignment.getAssignment() instanceof CtConstructorCall && this.objectPassedOnAnotherObject((CtConstructorCall)assignment.getAssignment(), refsToTargetObject)) {
                return null;
            }
            refsToTargetObject.remove(this.getVariableFromExpression(assignment.getAssigned()));
            if (!currentResult.contains((Object)TraverseState.CLOSE) && refsToTargetObject.isEmpty()) {
                return TraverseState.NO_CLOSE;
            }
        }
        if (assignment.getAssignment() instanceof CtConstructorCall && this.objectPassedOnAnotherObject(constructInvocation = (CtConstructorCall)assignment.getAssignment(), refsToTargetObject)) {
            return TraverseState.CLOSE;
        }
        return null;
    }

    private boolean objectPassedOnAnotherObject(CtConstructorCall<?> constructInvocation, Set<CtVariableReference<?>> refsToTargetObject) {
        if (constructInvocation.getExecutable().getExecutableDeclaration() == null) {
            return false;
        }
        if (constructInvocation.getExecutable().getExecutableDeclaration().getThrownTypes().isEmpty()) {
            for (CtExpression arg : constructInvocation.getArguments()) {
                boolean constInConst;
                if (arg instanceof CtVariableAccess && refsToTargetObject.contains(this.getVariableFromExpression(arg))) {
                    return true;
                }
                if (!(arg instanceof CtConstructorCall) || !(constInConst = this.objectPassedOnAnotherObject((CtConstructorCall)arg, refsToTargetObject))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTargetInvocation(CtInvocation<?> inv) {
        for (InvocationWrapper invWrap : this.invocationWrappers) {
            if (!invWrap.isSameInvocation(inv)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameSimpleName(CtInvocation<?> inv) {
        for (InvocationWrapper invWrap : this.invocationsObjectsPass) {
            if (!invWrap.isSameInvocationName(inv)) continue;
            return true;
        }
        return false;
    }

    private CtVariableReference<?> getVariableFromExpression(CtExpression<?> expression) {
        return ((CtVariableAccess)expression).getVariable();
    }

    private static enum TraverseState {
        CLOSE,
        NO_CLOSE;

    }
}

