/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.utils.traverse;

import com.pvsstudio.dataflow.taint.utils.traverse.BranchContainer;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchProcessor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;

public class NormalBranchProcessor
implements BranchProcessor {
    @Nullable
    private BranchContainer container;

    @Override
    public void processSanitizedElement(CtElement initial, CtElement border) {
        if (this.container == null) {
            this.container = BranchContainer.getContainer(initial, border);
        }
        if (this.container != null) {
            this.container.disableBranch(initial, border);
        }
    }

    @Override
    public boolean onVisitCtConditional(CtElement previousElement, CtConditional<?> conditional) {
        if (this.container == null) {
            this.container = BranchContainer.getContainer(conditional);
            CtRole role = previousElement.getRoleInParent();
            if (CtRole.THEN.equals((Object)role) || CtRole.ELSE.equals((Object)role)) {
                this.container.addElementToContinue(conditional.getParent(), role);
                return false;
            }
            return true;
        }
        CtRole parentRole = previousElement.getRoleInParent();
        if (CtRole.CONDITION.equals((Object)parentRole)) {
            this.container.setConditionVisited();
            return false;
        }
        if (!this.container.isLogicalConditionVisited()) {
            this.container.addElementToContinue(conditional.getParent(), parentRole);
            return false;
        }
        return !(CtRole.THEN.equals((Object)parentRole) && !this.container.isThenEnable() || CtRole.ELSE.equals((Object)parentRole) && !this.container.isElseEnable());
    }

    @Override
    public List<CtElement> getElementsToContinue() {
        return this.container != null ? this.container.getElementsToContinue() : Collections.emptyList();
    }
}

