/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.utils.traverse;

import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchContainer;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchProcessor;
import com.pvsstudio.dataflow.taint.utils.traverse.NormalBranchProcessor;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import spoon.reflect.code.CtConditional;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;

public class BranchProcessorFactory {
    private BranchProcessorFactory() {
    }

    private static BranchProcessor getEmpty() {
        return new BranchProcessor(){
            final List<CtElement> elementsToContinue = new LinkedList<CtElement>();

            @Override
            public void processSanitizedElement(CtElement initial, CtElement border) {
                Pair<CtConditional<?>, CtRole> pair = BranchContainer.detectCtCondition(initial, border);
                if (CtRole.CONDITION.equals(pair.getRight())) {
                    this.elementsToContinue.add(initial.getParent());
                }
            }

            @Override
            public boolean onVisitCtConditional(CtElement previousElement, CtConditional<?> conditional) {
                return true;
            }

            @Override
            public List<CtElement> getElementsToContinue() {
                return this.elementsToContinue;
            }
        };
    }

    public static BranchProcessor getProcessor(ChainElement current, ChainElement initial, DefUseChain chain) {
        if (current == initial || chain.getFirstChainElement() == current) {
            return new NormalBranchProcessor();
        }
        return BranchProcessorFactory.getEmpty();
    }
}

