/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.utils.traverse;

import com.pvsstudio.dataflow.taint.utils.traverse.ReverseBorderedScanner;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;

public class BranchContainer {
    private final CtConditional<?> conditional;
    private boolean thenEnable = true;
    private boolean elseEnable = true;
    private List<Pair<CtElement, CtRole>> elementsToContinue = new LinkedList<Pair<CtElement, CtRole>>();
    private boolean logicalConditionVisited = false;

    @Nullable
    public static BranchContainer getContainer(CtElement element, CtElement border) {
        Pair<CtConditional<?>, CtRole> ctConditionalDetected = BranchContainer.detectCtCondition(element, border);
        return ctConditionalDetected.getRight() != null ? new BranchContainer((CtConditional)ctConditionalDetected.getLeft()) : null;
    }

    public static BranchContainer getContainer(CtConditional<?> conditional) {
        return new BranchContainer(conditional);
    }

    public static Pair<CtConditional<?>, CtRole> detectCtCondition(CtElement element, CtElement border) {
        final MutableObject result = new MutableObject(null);
        ReverseBorderedScanner borderedScanner = new ReverseBorderedScanner(border){

            @Override
            public <T> void visitCtConditional(CtConditional<T> ctConditional) {
                if (this.getPreviousElement() != null && result.getValue() == null) {
                    result.setValue((Object)Pair.of(ctConditional, (Object)this.getPreviousElement().getRoleInParent()));
                }
            }
        };
        borderedScanner.scan(element);
        return result.getValue() != null ? (Pair)result.getValue() : Pair.of(null, null);
    }

    private static CtRole getDisabledBranch(CtElement el, CtElement border) {
        boolean flag = true;
        while (el != null && el != border) {
            if (el instanceof CtUnaryOperator && ((CtUnaryOperator)el).getKind().equals((Object)UnaryOperatorKind.NOT)) {
                flag = !flag;
            }
            el = el.getParent();
        }
        return flag ? CtRole.THEN : CtRole.ELSE;
    }

    private BranchContainer(CtConditional<?> conditional) {
        this.conditional = conditional;
    }

    private void disableBranch(CtRole result) {
        if (result != null) {
            if (result == CtRole.THEN) {
                this.thenEnable = false;
            } else if (result == CtRole.ELSE) {
                this.elseEnable = false;
            }
        }
    }

    public void disableBranch(CtElement element, CtElement border) {
        Pair<CtConditional<?>, CtRole> ctConditionalDetected = BranchContainer.detectCtCondition(element, border);
        if (ctConditionalDetected.getRight() == null) {
            return;
        }
        if (((CtRole)ctConditionalDetected.getRight()).equals((Object)CtRole.CONDITION)) {
            this.disableBranch(BranchContainer.getDisabledBranch(element, border));
            this.setConditionVisited();
        }
    }

    public void addElementToContinue(CtElement element, CtRole role) {
        this.elementsToContinue.add((Pair<CtElement, CtRole>)Pair.of((Object)element, (Object)role));
    }

    public CtConditional<?> getConditional() {
        return this.conditional;
    }

    public boolean isThenEnable() {
        return this.thenEnable;
    }

    public boolean isElseEnable() {
        return this.elseEnable;
    }

    public boolean isLogicalConditionVisited() {
        return this.logicalConditionVisited;
    }

    public void setConditionVisited() {
        this.logicalConditionVisited = true;
    }

    public List<CtElement> getElementsToContinue() {
        this.elementsToContinue.removeIf(x -> x.getRight() == CtRole.THEN && !this.thenEnable || x.getRight() == CtRole.ELSE && !this.elseEnable);
        return this.elementsToContinue.stream().map(Pair::getLeft).collect(Collectors.toList());
    }
}

