/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.utils.tracer;

import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import com.pvsstudio.dataflow.interprocedural.StartCall;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintPrinter;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtElement;

public class TaintLoggingPrinter
implements TaintPrinter {
    private final Logger logger = LoggerFactory.getLogger(TaintLoggingPrinter.class);

    @Override
    public final void print(CtElement source, CallSite<?> startCallSite) {
        if (this.logger == null) {
            return;
        }
        CallSite<?> callSite = startCallSite;
        LinkedList<String> callSiteList = new LinkedList<String>();
        while (callSite instanceof IntermediateCallSite) {
            callSiteList.add(0, this.convertToString(callSite));
            callSite = ((IntermediateCallSite)callSite).getParent();
        }
        callSiteList.add(0, this.convertToString(callSite));
        callSiteList.forEach(x -> this.logger.warn("{} -> {}", (Object)Thread.currentThread().getName(), x));
        this.logger.warn("{} -> {} {} contains source {}{}", new Object[]{Thread.currentThread().getName(), startCallSite.getSignature(), this.getPositionString((CtElement)startCallSite.getExecutableFromCall()), source, this.getPositionString(source)});
    }

    protected final String getPositionString(CtElement element) {
        SourcePosition position = element.getPosition();
        return position instanceof NoSourcePosition ? "" : " (" + position.getFile().getName() + ":" + position.getLine() + ")";
    }

    private String convertToString(@NotNull CallSite<?> callSite) {
        if (callSite instanceof StartCall) {
            StartCall startCall = (StartCall)callSite;
            return "Sink " + String.valueOf(startCall.getStartElement()) + this.getPositionString(startCall.getStartElement()) + " in " + String.valueOf(startCall.getSignature()) + this.getPositionString((CtElement)callSite.getExecutableFromCall());
        }
        if (callSite instanceof ExecutableReturn) {
            CallSite<?> parent = ((ExecutableReturn)callSite).getParent();
            return String.valueOf(parent.getSignature()) + this.getPositionString((CtElement)parent.getExecutableFromCall()) + " returns to " + String.valueOf(callSite.getSignature()) + this.getPositionString((CtElement)callSite.getExecutableFromCall());
        }
        if (callSite instanceof ExecutableCall) {
            return "called in " + callSite.getSignature().toString() + this.getPositionString((CtElement)callSite.getExecutableFromCall());
        }
        if (callSite instanceof InvocationCall) {
            CallSite<?> parent = ((InvocationCall)callSite).getParent();
            String positionString = parent instanceof InvocationCall ? this.getPositionString((CtElement)parent.getExecutableFromCall()) : "";
            return String.valueOf(parent.getSignature()) + positionString + " invokes " + String.valueOf(callSite.get()) + this.getPositionString((CtElement)((InvocationCall)callSite).get());
        }
        throw new IllegalArgumentException("Unexpected CallSite type " + String.valueOf(callSite));
    }
}

