/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.sink;

import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import com.pvsstudio.dataflow.taint.TaintScanner;
import com.pvsstudio.dataflow.taint.sink.InvocationSink;
import com.pvsstudio.dataflow.taint.sink.Sink;
import com.pvsstudio.dataflow.taint.sink.VariableSink;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.path.CtRole;

public class SinkScanner {
    private final TaintRuleStrategy strategy;
    private final CtElement element;
    private final CtExecutable<?> elementExecutable;

    public SinkScanner(TaintRuleStrategy strategy, CtElement element) {
        this.strategy = strategy;
        this.element = element;
        this.elementExecutable = (CtExecutable)element.getParent(CtExecutable.class);
    }

    public List<Sink> findSinks() {
        final LinkedList sinkAccesses = new LinkedList();
        final HashMap simpleUsages = new HashMap();
        final LinkedList<Sink> sinks = new LinkedList<Sink>();
        TaintScanner scanner = new TaintScanner(){

            public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
                if (this.getConditionRole() != CtRole.CONDITION && SinkScanner.this.strategy.isSource((CtElement)ctConstructorCall, SinkScanner.this.elementExecutable)) {
                    sinks.add(new InvocationSink((CtAbstractInvocation<?>)ctConstructorCall));
                } else {
                    super.visitCtConstructorCall(ctConstructorCall);
                }
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                if (this.getConditionRole() != CtRole.CONDITION) {
                    sinks.add(new InvocationSink((CtAbstractInvocation<?>)invocation));
                } else {
                    super.visitCtInvocation(invocation);
                }
            }

            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                this.visitCtVariableAccess((CtVariableAccess<?>)fieldRead);
            }

            public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
                this.visitCtVariableAccess((CtVariableAccess<?>)fieldWrite);
            }

            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                this.visitCtVariableAccess((CtVariableAccess<?>)variableRead);
            }

            public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
                this.visitCtVariableAccess((CtVariableAccess<?>)variableWrite);
            }

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                this.scan((CtElement)arrayWrite.getTarget());
            }

            public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
                this.scan((CtElement)arrayRead.getTarget());
            }

            private void visitCtVariableAccess(CtVariableAccess<?> variableAccess) {
                if (this.getConditionRole() == CtRole.CONDITION) {
                    Variable variable = VariableFactory.parseFromAst(variableAccess);
                    simpleUsages.computeIfAbsent(variable, k -> new LinkedList());
                    ((List)simpleUsages.get(variable)).add(variableAccess);
                } else {
                    sinkAccesses.add(variableAccess);
                }
            }
        };
        scanner.scan(this.element);
        sinkAccesses.stream().map(varSink -> new VariableSink((CtVariableAccess<?>)varSink, (List)simpleUsages.get(VariableFactory.parseFromAst((CtElement)varSink)))).forEach(sinks::add);
        return sinks;
    }
}

