/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.iterator;

import com.pvsstudio.dataflow.defuse.chain.DefUseChainEdge;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.Graph;
import org.jgrapht.traverse.AbstractGraphIterator;

public class SimpleDFSIterator
extends AbstractGraphIterator<ChainElement, DefUseChainEdge> {
    private final Stack<ChainElement> stack = new Stack();
    private final Set<ChainElement> visited = Collections.newSetFromMap(new IdentityHashMap());

    public SimpleDFSIterator(Graph<ChainElement, DefUseChainEdge> graph, ChainElement startVertex) {
        super(graph);
        this.stack.add(startVertex);
    }

    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public ChainElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes to traverse.");
        }
        ChainElement current = this.stack.pop();
        if (this.visited.add(current)) {
            for (DefUseChainEdge edge : this.graph.incomingEdgesOf((Object)current)) {
                ChainElement neighbor = edge.getSource();
                if (this.visited.contains(neighbor)) continue;
                this.stack.add(neighbor);
            }
        }
        return current;
    }
}

