/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.iterator;

import com.pvsstudio.dataflow.defuse.chain.DefUseChainEdge;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.traverse.AbstractGraphIterator;

public class SimpleBFSIterator
extends AbstractGraphIterator<ChainElement, DefUseChainEdge> {
    protected final Queue<ChainElement> queue = new LinkedList<ChainElement>();
    protected final Set<ChainElement> visited = Collections.newSetFromMap(new IdentityHashMap());

    public SimpleBFSIterator(Graph<ChainElement, DefUseChainEdge> graph, ChainElement startVertex) {
        super(graph);
        this.queue.add(startVertex);
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public ChainElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes to traverse.");
        }
        return this.queue.poll();
    }

    public void addIncomingOf(ChainElement chainElement) {
        if (this.visited.add(chainElement)) {
            for (DefUseChainEdge edge : this.graph.incomingEdgesOf((Object)chainElement)) {
                ChainElement neighbor = edge.getSource();
                if (this.visited.contains(neighbor)) continue;
                this.queue.add(neighbor);
            }
        }
    }
}

