/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache.rule;

import com.google.errorprone.annotations.ThreadSafe;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.taint.cache.method.DummyTaintByMethodCache;
import com.pvsstudio.dataflow.taint.cache.method.TaintByMethodCache;
import com.pvsstudio.dataflow.taint.cache.rule.TaintByRuleCache;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtExecutable;

@ThreadSafe
public class DefaultTaintByRuleCache
implements TaintByRuleCache {
    private final Map<MethodSignature, TaintByMethodCache> cacheByMethod = new ConcurrentHashMap<MethodSignature, TaintByMethodCache>();
    private final Provider<TaintByMethodCache> byMethodCacheProvider;

    @Inject
    public DefaultTaintByRuleCache(Provider<TaintByMethodCache> byMethodCacheProvider) {
        this.byMethodCacheProvider = byMethodCacheProvider;
    }

    @Override
    @NotNull
    public TaintByMethodCache byMethod(CtExecutable<?> executable) {
        MethodSignature signature = MethodSignature.of(executable);
        return signature == null ? DummyTaintByMethodCache.INSTANCE : this.cacheByMethod.computeIfAbsent(signature, s -> (TaintByMethodCache)this.byMethodCacheProvider.get());
    }
}

