/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache.method;

import com.google.errorprone.annotations.ThreadSafe;
import com.pvsstudio.dataflow.taint.cache.expression.TaintByExpressionCache;
import com.pvsstudio.dataflow.taint.cache.method.TaintByMethodCache;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import spoon.reflect.declaration.CtElement;

@ThreadSafe
public class DefaultTaintByMethodCache
implements TaintByMethodCache {
    private final Map<CtElement, TaintByExpressionCache> cacheByExpression = Collections.synchronizedMap(new IdentityHashMap());
    private final Provider<TaintByExpressionCache> byExpressionCacheProvider;

    @Inject
    public DefaultTaintByMethodCache(Provider<TaintByExpressionCache> byExpressionCacheProvider) {
        this.byExpressionCacheProvider = byExpressionCacheProvider;
    }

    @Override
    public TaintByExpressionCache byElement(CtElement expression) {
        return this.cacheByExpression.computeIfAbsent(expression, e -> (TaintByExpressionCache)this.byExpressionCacheProvider.get());
    }
}

