/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache.expression;

import com.pvsstudio.dataflow.taint.cache.expression.DefaultTaintByExpressionCache;
import com.pvsstudio.dataflow.taint.cache.expression.TaintByExpressionCache;
import java.util.ConcurrentModificationException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtParameterReference;

public class SynchronizedTaintByExpressionCache
extends DefaultTaintByExpressionCache {
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public void lock() {
        this.lock.lock();
        super.lock();
    }

    @Override
    public void unlock() {
        super.unlock();
        this.lock.unlock();
    }

    @Override
    public void addOutgoingParameter(CtParameterReference<?> parameter) {
        this.assertLockedByCurrentThread();
        super.addOutgoingParameter(parameter);
    }

    @Override
    public Set<CtParameterReference<?>> getOutgoingParameters() {
        this.assertLockedByCurrentThread();
        return super.getOutgoingParameters();
    }

    @Override
    public void addSource(CtElement element) {
        this.assertLockedByCurrentThread();
        super.addSource(element);
    }

    @Override
    public Set<CtElement> getSources() {
        this.assertLockedByCurrentThread();
        return super.getSources();
    }

    @Override
    public void addConnection(CtAbstractInvocation<?> invocation) {
        this.assertLockedByCurrentThread();
        super.addConnection(invocation);
    }

    @Override
    public Set<CtAbstractInvocation<?>> getConnections() {
        this.assertLockedByCurrentThread();
        return super.getConnections();
    }

    @Override
    public boolean hasAnyInfo() {
        this.assertLockedByCurrentThread();
        return super.hasAnyInfo();
    }

    @Override
    public void addAll(TaintByExpressionCache another) {
        this.assertLockedByCurrentThread();
        super.addAll(another);
    }

    @Override
    public void clear() {
        this.assertLockedByCurrentThread();
        super.clear();
    }

    private void assertLockedByCurrentThread() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new ConcurrentModificationException("This cache is not locked by " + String.valueOf(Thread.currentThread()) + ", but is yse to use it");
        }
    }
}

