/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtExecutable;

public class VisitedCallsController {
    private final Multimap<CtExecutable<?>, ExecutableInfo> visitedExecutables = Multimaps.newSetMultimap(new IdentityHashMap(), () -> Collections.newSetFromMap(new IdentityHashMap()));

    public boolean isVisited(ExecutableCall executableCall, CtAbstractInvocation<?> abstractInvocation) {
        CtExecutable<?> previousExecutable;
        if (executableCall instanceof ExecutableReturn) {
            return false;
        }
        CallSite<?> parent = executableCall.getParent();
        int pos = executableCall.getParameterPos();
        CtExecutable caller = (CtExecutable)executableCall.get();
        if (caller == (previousExecutable = parent.getExecutableFromCall())) {
            return true;
        }
        Collection callersInfo = this.visitedExecutables.get(previousExecutable);
        return callersInfo.stream().filter(x -> x.getCaller() == caller).filter(x -> x.getParIndex() == pos).anyMatch(x -> x.isVisited(abstractInvocation));
    }

    public void addVisitedExecutable(ExecutableCall call, CtAbstractInvocation<?> invocation) {
        CtExecutable<?> previousExecutable = call.getParent().getExecutableFromCall();
        CtExecutable caller = (CtExecutable)call.get();
        int parameterPos = call.getParameterPos();
        Collection callersInfo = this.visitedExecutables.get(previousExecutable);
        Optional<ExecutableInfo> optionalExecutableInfo = callersInfo.stream().filter(x -> x.getCaller() == caller).filter(x -> x.getParIndex() == parameterPos).findAny();
        if (optionalExecutableInfo.isPresent()) {
            optionalExecutableInfo.get().addVisited(invocation);
        } else {
            ExecutableInfo target = new ExecutableInfo(caller, parameterPos);
            target.addVisited(invocation);
            this.visitedExecutables.put(previousExecutable, (Object)target);
        }
    }

    private static class ExecutableInfo {
        private final CtExecutable<?> caller;
        private final Set<CtAbstractInvocation<?>> invocations = Collections.newSetFromMap(new IdentityHashMap());
        private final int parIndex;

        public ExecutableInfo(CtExecutable<?> caller, int parameterIndex) {
            this.caller = caller;
            this.parIndex = parameterIndex;
        }

        public boolean isVisited(CtAbstractInvocation<?> abstractInvocation) {
            return this.invocations.contains(abstractInvocation);
        }

        public void addVisited(CtAbstractInvocation<?> abstractInvocation) {
            this.invocations.add(abstractInvocation);
        }

        public CtExecutable<?> getCaller() {
            return this.caller;
        }

        public int getParIndex() {
            return this.parIndex;
        }
    }
}

