/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache;

import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TaintVisitedChainElements {
    private final Map<ChainElement, Set<DefUseChain>> visitedHistory = new HashMap<ChainElement, Set<DefUseChain>>();
    private final Map<ChainElement, Set<DefUseChain>> stopTraversalPlace = new HashMap<ChainElement, Set<DefUseChain>>();

    public boolean isVisited(ChainElement element, DefUseChain chain) {
        return this.contains(this.visitedHistory, element, chain);
    }

    private boolean contains(Map<ChainElement, Set<DefUseChain>> history, ChainElement element, DefUseChain chain) {
        return Optional.of(history).map(h -> (Set)h.get(element)).filter(chains -> chains.contains(chain)).isPresent();
    }

    public void setVisited(ChainElement element, DefUseChain chain) {
        this.add(this.visitedHistory, element, chain);
    }

    private void add(Map<ChainElement, Set<DefUseChain>> history, ChainElement element, DefUseChain chain) {
        history.computeIfAbsent(element, k -> new HashSet()).add(chain);
    }

    public boolean isStopTraversalPlace(ChainElement element, DefUseChain chain) {
        return this.contains(this.stopTraversalPlace, element, chain);
    }

    public void setStopTraversalPlace(ChainElement element, DefUseChain chain) {
        this.add(this.stopTraversalPlace, element, chain);
    }
}

