/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache;

import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import com.pvsstudio.dataflow.taint.cache.expression.DefaultTaintByExpressionCache;
import com.pvsstudio.dataflow.taint.cache.expression.DummyTaintByExpressionCache;
import com.pvsstudio.dataflow.taint.cache.expression.TaintByExpressionCache;
import com.pvsstudio.dataflow.taint.cache.method.DummyTaintByMethodCache;
import com.pvsstudio.dataflow.taint.cache.method.TaintByMethodCache;
import com.pvsstudio.dataflow.taint.cache.rule.TaintByRuleCache;
import java.util.Set;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtParameterReference;

public class TaintCacheController {
    private final TaintByRuleCache currentRule;
    private final TaintByExpressionCache collected;
    private TaintByMethodCache currentMethod;
    private TaintByExpressionCache currentExpression;

    public TaintCacheController(TaintByRuleCache rule) {
        this.currentRule = rule;
        this.collected = new DefaultTaintByExpressionCache();
        this.currentMethod = DummyTaintByMethodCache.INSTANCE;
        this.currentExpression = DummyTaintByExpressionCache.INSTANCE;
    }

    public void setCurrentMethod(CtExecutable<?> executable) {
        this.removeCurrentExpression();
        this.currentMethod = this.currentRule.byMethod(executable);
        this.collected.clear();
    }

    public void setCurrentElement(CtElement expression) {
        this.currentExpression = this.currentMethod.byElement(expression);
        this.currentExpression.lock();
    }

    public void removeCurrentExpression() {
        this.currentExpression.unlock();
        this.currentExpression = DummyTaintByExpressionCache.INSTANCE;
    }

    public void addConnection(InvocationCall callSite) {
        this.currentExpression.addConnection((CtAbstractInvocation)callSite.get());
    }

    public void addOutgoingParameter(CtParameterReference<?> outgoingParameter, CtExecutable<?> executable) {
        TaintByMethodCache methodCache = this.currentRule.byMethod(executable);
        if (methodCache == this.currentMethod) {
            this.currentExpression.addOutgoingParameter(outgoingParameter);
        }
    }

    public void addSource(CtElement source) {
        this.currentExpression.addSource(source);
    }

    public boolean hasAnyInfo() {
        return this.currentExpression.hasAnyInfo();
    }

    public void collectFromCurrentExpression() {
        this.collected.addAll(this.currentExpression);
    }

    public Set<CtElement> getCollectedSources() {
        return this.collected.getSources();
    }

    public Set<CtParameterReference<?>> getCollectedParameters() {
        return this.collected.getOutgoingParameters();
    }

    public Set<CtAbstractInvocation<?>> getCollectedConnections() {
        return this.collected.getConnections();
    }
}

