/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint.cache;

import com.google.errorprone.annotations.ThreadSafe;
import com.pvsstudio.dataflow.taint.cache.TaintCache;
import com.pvsstudio.dataflow.taint.cache.rule.TaintByRuleCache;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class DefaultTaintCache
implements TaintCache {
    private final Map<Class<?>, TaintByRuleCache> cacheByClass = new ConcurrentHashMap();
    private final Provider<TaintByRuleCache> byRuleCacheProvider;

    @Inject
    public DefaultTaintCache(Provider<TaintByRuleCache> byRuleCacheProvider) {
        this.byRuleCacheProvider = byRuleCacheProvider;
    }

    @Override
    @NotNull
    public TaintByRuleCache byRule(Class<?> ruleClass) {
        return this.cacheByClass.computeIfAbsent(ruleClass, k -> (TaintByRuleCache)this.byRuleCacheProvider.get());
    }
}

