/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Field;
import com.pvsstudio.dataflow.intermediate.Variable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;

public class TargetFieldHolder {
    private final Map<Variable, Map<Field, Set<DefUseChain>>> fieldChainsForVariable = new HashMap<Variable, Map<Field, Set<DefUseChain>>>();

    public void setTarget(Variable owner, Set<DefUseChain> targetVariablesChains, Field targetVariable) {
        this.fieldChainsForVariable.computeIfAbsent(owner, x -> new HashMap()).computeIfAbsent(targetVariable, x -> new HashSet()).addAll(targetVariablesChains.stream().filter(chain -> chain.getOwnerVariable().equals(targetVariable)).collect(Collectors.toSet()));
    }

    public Set<Field> getTargetFieldsFor(Variable owner) {
        return this.fieldChainsForVariable.containsKey(owner) ? this.fieldChainsForVariable.get(owner).keySet() : Collections.emptySet();
    }

    public boolean stopTraverseIf(Predicate<Field> stopTraversePredicate, Variable owner, ChainElement element) {
        Map<Field, Set<DefUseChain>> fields = this.fieldChainsForVariable.get(owner);
        if (fields == null || fields.isEmpty() || element.getElement() == null) {
            return false;
        }
        Iterator<Field> iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            if (!stopTraversePredicate.test(field)) continue;
            Set<DefUseChain> chains = fields.get(field);
            if (chains.stream().noneMatch(chain -> chain.containsVertex(element))) {
                CtElement parent = element.getElement().getParent();
                if (parent instanceof CtBlock && parent.getParent() instanceof CtExecutable) {
                    chains.clear();
                }
            } else {
                chains.removeIf(x -> x.containsVertex(element));
            }
            if (!chains.isEmpty()) continue;
            iterator.remove();
        }
        if (fields.isEmpty()) {
            this.fieldChainsForVariable.remove(owner);
            return true;
        }
        return false;
    }

    public boolean doesVariableHaveFields(Variable variable) {
        return this.fieldChainsForVariable.containsKey(variable);
    }

    public void removeVariable(Variable variable) {
        this.fieldChainsForVariable.remove(variable);
    }

    public void removeFieldChains(Variable owner, ChainElement element) {
        if (!this.fieldChainsForVariable.containsKey(owner)) {
            return;
        }
        Map<Field, Set<DefUseChain>> fields = this.fieldChainsForVariable.get(owner);
        fields.keySet().forEach(k -> ((Set)fields.get(k)).removeIf(chain -> chain.getFirstChainElement() == element));
        fields.keySet().removeIf(value -> ((Set)fields.get(value)).isEmpty());
        this.fieldChainsForVariable.keySet().removeIf(v -> this.fieldChainsForVariable.get(v).isEmpty());
    }
}

