/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.contradiction.BranchCondition;
import com.pvsstudio.dataflow.contradiction.ContradictionHelper;
import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.defuse.element.ChainElementIf;
import com.pvsstudio.dataflow.graph.ConditionSanitizationResult;
import com.pvsstudio.dataflow.graph.FlowResult;
import com.pvsstudio.dataflow.graph.GraphUtils;
import com.pvsstudio.dataflow.intermediate.Field;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.CallSiteSequenceController;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import com.pvsstudio.dataflow.interprocedural.strategy.CallSiteStrategy;
import com.pvsstudio.dataflow.taint.GraphProvider;
import com.pvsstudio.dataflow.taint.TaintFlag;
import com.pvsstudio.dataflow.taint.TaintPath;
import com.pvsstudio.dataflow.taint.TaintScanner;
import com.pvsstudio.dataflow.taint.TaintSource;
import com.pvsstudio.dataflow.taint.TargetFieldHolder;
import com.pvsstudio.dataflow.taint.cache.TaintCacheController;
import com.pvsstudio.dataflow.taint.cache.TaintVisitedChainElements;
import com.pvsstudio.dataflow.taint.iterator.SimpleBFSIterator;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.dataflow.taint.utils.Usage;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchContainer;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchProcessor;
import com.pvsstudio.dataflow.taint.utils.traverse.BranchProcessorFactory;
import com.pvsstudio.dataflow.taint.utils.traverse.NormalBranchProcessor;
import com.pvsstudio.dataflow.taint.utils.traverse.ReverseBorderedScanner;
import com.pvsstudio.dataflow.taint.utils.traverse.VariableProcessor;
import fr.inria.controlflow.NodeKind;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;

public class TaintWalker {
    protected static final Logger logger = LoggerFactory.getLogger(TaintWalker.class);
    private final TaintRuleStrategy ruleStrategy;
    private final GraphProvider graphProvider;
    private final TaintPath<CtExecutable<?>> path;
    private final TaintCacheController cache;
    private final TargetFieldHolder fieldHolder = new TargetFieldHolder();
    private List<TaintSource> sources = new LinkedList<TaintSource>();
    private List<IntermediateCallSite<?>> callSites = new LinkedList();
    private CallSiteStrategy<?> walkStrategy;
    private CallSite<?> currentCallSite;

    public TaintWalker(TaintRuleStrategy strategy, GraphProvider graphProvider, TaintPath<CtExecutable<?>> taintPath, TaintCacheController cache) {
        this.ruleStrategy = strategy;
        this.graphProvider = graphProvider;
        this.path = taintPath;
        this.cache = cache;
    }

    public void walk(@NotNull CallSiteStrategy<?> strategy) {
        this.walkStrategy = strategy;
        this.currentCallSite = strategy.getCallSite();
        CtExecutable<?> executable = this.currentCallSite.getExecutableFromCall();
        this.graphProvider.update(executable);
        this.cache.setCurrentMethod(executable);
        strategy.getInitialElements().forEach(this::processElement);
        this.processCollectedCacheInfo(this.currentCallSite);
    }

    private void processElement(CtElement element) {
        try {
            this.cache.setCurrentElement(element);
            if (this.cache.hasAnyInfo()) {
                this.cache.collectFromCurrentExpression();
            } else {
                this.walkForElement(element);
            }
        }
        finally {
            this.cache.removeCurrentExpression();
        }
    }

    private void processCollectedCacheInfo(CallSite<?> callSite) {
        this.cache.getCollectedSources().forEach(this::addSource);
        this.cache.getCollectedParameters().forEach(pr -> this.createCallSites((CtElement)pr, callSite));
        this.cache.getCollectedConnections().forEach(inv -> this.createCallSites((CtElement)inv, callSite));
    }

    protected void walkForElement(@NotNull CtElement element) {
        DefUseGraph du = this.graphProvider.getDefUseGraph();
        if (du == null) {
            logger.debug("{} ->  Method traversal stopped, unsupported item found: {}", (Object)Thread.currentThread().getName(), (Object)this.currentCallSite.getSignature());
            return;
        }
        Map<DefUseChain, Usage> chainsToIterate = this.getFromInitial(element);
        this.walkStrategy.prepareInitialUsages(chainsToIterate);
        TaintVisitedChainElements visitedElements = new TaintVisitedChainElements();
        while (!chainsToIterate.isEmpty()) {
            LinkedHashMap<DefUseChain, Usage> parentChains = new LinkedHashMap<DefUseChain, Usage>();
            chainsToIterate.forEach((chain, node) -> this.scanPaths((Usage)node, (Map<DefUseChain, Usage>)parentChains, (DefUseChain)chain, visitedElements));
            chainsToIterate = parentChains;
        }
    }

    protected Map<DefUseChain, Usage> getFromInitial(CtElement initialElement) {
        final LinkedHashMap<DefUseChain, Usage> result = new LinkedHashMap<DefUseChain, Usage>();
        VariableProcessor processor = new VariableProcessor(){

            @Override
            public void visitCtVariableAccess(CtVariableAccess<?> variableAccess) {
                if (TaintWalker.this.isTargetType(variableAccess)) {
                    TaintWalker.this.getChainsWithUsage(variableAccess, result);
                }
            }

            @Override
            public void visitCtFieldAccess(CtFieldAccess<?> fieldAccess) {
                if (!TaintWalker.this.isTargetType((CtVariableAccess<?>)fieldAccess)) {
                    return;
                }
                CtVariableAccess<?> mainVariableAccess = TaintWalker.this.getMainVariableFromField(fieldAccess);
                Variable fieldVariable = VariableFactory.parseFromAst(fieldAccess);
                LinkedHashMap<DefUseChain, Usage> fieldUsages = new LinkedHashMap<DefUseChain, Usage>();
                TaintWalker.this.getChainsWithUsage((CtVariableAccess<?>)fieldAccess, (Map<DefUseChain, Usage>)fieldUsages);
                if (fieldVariable instanceof Field) {
                    TaintWalker.this.fieldHolder.setTarget(VariableFactory.parseFromAst(mainVariableAccess), fieldUsages.keySet(), (Field)fieldVariable);
                }
                TaintWalker.this.getChainsWithUsage(mainVariableAccess, result);
            }
        };
        this.getScanner(processor, true, null).scan(initialElement);
        return result;
    }

    protected TaintScanner getScanner(final VariableProcessor variableProcessor, final boolean areSourceAccessibleFlag, final @Nullable Variable currentVariable) {
        return new TaintScanner(){

            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                variableProcessor.visitCtFieldAccess((CtFieldAccess<?>)fieldRead);
            }

            public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
                variableProcessor.visitCtFieldAccess((CtFieldAccess<?>)fieldWrite);
            }

            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                variableProcessor.visitCtVariableAccess((CtVariableAccess<?>)variableRead);
            }

            public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
                variableProcessor.visitCtVariableAccess((CtVariableAccess<?>)variableWrite);
            }

            public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
                this.scan((CtElement)arrayRead.getTarget());
            }

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                this.scan((CtElement)arrayWrite.getTarget());
            }

            public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
                if (TaintWalker.this.isSource((CtElement)ctConstructorCall) && areSourceAccessibleFlag) {
                    TaintWalker.this.addSource((CtElement)ctConstructorCall);
                    return;
                }
                if (TaintWalker.this.isTargetType(ctConstructorCall.getType()) || CtRole.CONDITION == this.getConditionRole()) {
                    this.scan(ctConstructorCall.getArguments());
                }
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                boolean isInsideCondition;
                boolean bl = isInsideCondition = CtRole.CONDITION == this.getConditionRole();
                if (!isInsideCondition) {
                    Context context = TaintWalker.this.getLocalContext(false, true, null);
                    if (TaintWalker.this.ruleStrategy.isSanitized((CtElement)invocation, context)) {
                        return;
                    }
                    if (TaintWalker.this.isSource((CtElement)invocation) && areSourceAccessibleFlag) {
                        TaintWalker.this.addSource((CtElement)invocation);
                        return;
                    }
                }
                if (TaintWalker.this.currentCallSite instanceof ExecutableCall && this.scanReturnedArgument((CtAbstractInvocation<?>)invocation, (ExecutableCall)TaintWalker.this.currentCallSite)) {
                    return;
                }
                if (!TaintWalker.this.isTargetType(invocation.getType()) && !isInsideCondition) {
                    return;
                }
                if (currentVariable != null && TaintWalker.this.fieldHolder.doesVariableHaveFields(currentVariable)) {
                    return;
                }
                if (!TaintWalker.this.pushInvocationCall((CtAbstractInvocation<?>)invocation, TaintWalker.this.currentCallSite)) {
                    this.scan(CtRole.ARGUMENT, invocation.getArguments());
                    this.scanTarget(invocation, TaintWalker.this::isTargetType);
                }
            }
        };
    }

    protected CtVariableAccess<?> getMainVariableFromField(CtFieldAccess<?> fieldAccess) {
        while (fieldAccess.getTarget() instanceof CtFieldAccess) {
            fieldAccess = (CtFieldAccess)fieldAccess.getTarget();
        }
        if (fieldAccess.getTarget() instanceof CtVariableAccess) {
            return (CtVariableAccess)fieldAccess.getTarget();
        }
        return fieldAccess;
    }

    protected void getChainsWithUsage(CtVariableAccess<?> variable, Map<DefUseChain, Usage> chainsWithUsages) {
        DefUseGraph graph = this.graphProvider.getDefUseGraph();
        if (graph == null) {
            return;
        }
        for (DefUseChain chain : graph.getChains(variable)) {
            ChainElement chainElement = chain.find((CtElement)variable);
            if (chainElement == null) continue;
            if (chainsWithUsages.containsKey(chain)) {
                chainsWithUsages.get(chain).addVariableAccess(variable);
                continue;
            }
            Usage newUsage = new Usage(chainElement);
            newUsage.addVariableAccess(variable);
            chainsWithUsages.put(chain, newUsage);
        }
    }

    protected void scanPaths(Usage initial, Map<DefUseChain, Usage> parentChains, DefUseChain chain, TaintVisitedChainElements taintVisitedChainElements) {
        SimpleBFSIterator iterator = new SimpleBFSIterator(chain, initial.getChainElement());
        this.addConcatFlag(initial);
        ChainElement firstEl = chain.getFirstChainElement();
        Variable variable = chain.getOwnerVariable();
        while (iterator.hasNext()) {
            ChainElement cur = iterator.next();
            if (taintVisitedChainElements.isVisited(cur, chain)) {
                if (taintVisitedChainElements.isStopTraversalPlace(cur, chain)) continue;
                iterator.addIncomingOf(cur);
                continue;
            }
            taintVisitedChainElements.setVisited(cur, chain);
            if (firstEl != cur && this.fieldHolder.doesVariableHaveFields(variable)) {
                this.updateInspectedFieldChains(variable, initial.getChainElement(), cur, parentChains);
                if (!this.fieldHolder.doesVariableHaveFields(variable) || this.fieldHolder.stopTraverseIf(field -> this.shouldStopTraversal(cur, chain, initial, (Variable)field, parentChains), variable, cur)) continue;
                iterator.addIncomingOf(cur);
                continue;
            }
            if (this.shouldStopTraversal(cur, chain, initial, variable, parentChains)) {
                taintVisitedChainElements.setStopTraversalPlace(cur, chain);
                continue;
            }
            if (firstEl == cur) {
                this.findDefiningChains(chain, parentChains, initial);
            }
            iterator.addIncomingOf(cur);
        }
    }

    protected CtElement getDefiningExpression(DefUseChain chain) {
        CtElement firstChainElement;
        if (chain.getDefaultExpression() != null) {
            return chain.getDefaultExpression();
        }
        if (chain.getFirstChainElement().getElement() != null && (firstChainElement = chain.getFirstChainElement().getElement().getParent()) instanceof CtForEach) {
            return ((CtForEach)firstChainElement).getExpression();
        }
        return null;
    }

    private void findDefiningChains(final DefUseChain currentChain, final Map<DefUseChain, Usage> parentChains, final Usage initial) {
        final Variable currentVariable = currentChain.getOwnerVariable();
        VariableProcessor processor = new VariableProcessor(){

            @Override
            public void visitCtVariableAccess(CtVariableAccess<?> variableAccess) {
                if (TaintWalker.this.isTargetType(variableAccess) || TaintWalker.this.fieldHolder.doesVariableHaveFields(currentVariable)) {
                    TaintWalker.this.updateVars(currentChain, variableAccess, parentChains, initial);
                }
            }

            @Override
            public void visitCtFieldAccess(CtFieldAccess<?> fieldAccess) {
                this.visitCtVariableAccess((CtVariableAccess<?>)fieldAccess);
            }
        };
        boolean accessibleFlag = this.areAccessible(currentChain.getFirstChainElement(), initial.getChainElement());
        this.getScanner(processor, accessibleFlag, currentVariable).scan(this.getDefiningExpression(currentChain));
        parentChains.remove(currentChain);
    }

    private void updateVars(DefUseChain currentChain, CtVariableAccess<?> newVariableAccess, Map<DefUseChain, Usage> parentChains, Usage initial) {
        CtVariableAccess<?> ownerVariableAccess = newVariableAccess instanceof CtFieldAccess ? this.getMainVariableFromField((CtFieldAccess)newVariableAccess) : newVariableAccess;
        Variable newVariable = VariableFactory.parseFromAst(newVariableAccess);
        Variable currentVariable = currentChain.getOwnerVariable();
        Map<DefUseChain, Usage> usages = new LinkedHashMap<DefUseChain, Usage>();
        if (this.fieldHolder.doesVariableHaveFields(currentVariable)) {
            this.getChainsWithUsage(ownerVariableAccess, usages);
            Variable ownerVariable = VariableFactory.parseFromAst(ownerVariableAccess);
            Set<DefUseChain> ownerChains = usages.keySet();
            for (Field field : this.fieldHolder.getTargetFieldsFor(currentVariable)) {
                Field newField = VariableFactory.swappedOwner(newVariable, field);
                Set<DefUseChain> fieldChains = this.graphProvider.getDefUseGraph().getChains(newField).stream().filter(fieldChain -> ownerChains.stream().anyMatch(ownerChain -> ownerChain.containsVertex(fieldChain.getFirstChainElement()))).collect(Collectors.toSet());
                this.fieldHolder.setTarget(ownerVariable, fieldChains, newField);
            }
        } else {
            usages = this.getFromInitial((CtElement)newVariableAccess);
        }
        usages.forEach((chain, usage) -> {
            if (chain != currentChain && this.areAccessible(usage.getChainElement(), initial.getChainElement())) {
                if (!parentChains.containsKey(chain)) {
                    parentChains.put((DefUseChain)chain, (Usage)usage);
                } else {
                    usage.getVariableAccess().forEach(access -> ((Usage)parentChains.get(chain)).addVariableAccess((CtVariableAccess<?>)access));
                }
            }
        });
    }

    private void updateInspectedFieldChains(Variable variable, ChainElement initial, ChainElement element, Map<DefUseChain, Usage> parentChains) {
        CtElement statement = element.getElement();
        if (statement instanceof CtAssignment && this.areAccessible(element, initial)) {
            CtAssignment assignment = (CtAssignment)statement;
            this.fieldHolder.removeFieldChains(variable, element);
            parentChains.putAll(this.getFromInitial((CtElement)assignment.getAssignment()));
        }
    }

    private boolean shouldStopTraversal(ChainElement chainElement, DefUseChain chain, Usage initial, Variable targetVariable, Map<DefUseChain, Usage> parentChains) {
        boolean chainOfTargetVariable = chain.getOwnerVariable().equals(targetVariable);
        if (chainElement.getNode().getKind().equals((Object)NodeKind.BEGIN) && chainOfTargetVariable) {
            CtVariableReference<?> ownerVariableReference = chain.getOwnerVariableReference();
            if (this.isSource((CtElement)ownerVariableReference)) {
                this.addSource((CtElement)ownerVariableReference);
            } else {
                this.createCallSites((CtElement)ownerVariableReference, this.currentCallSite);
            }
            return true;
        }
        if (chainElement instanceof ChainElementIf) {
            ChainElementIf chainElementIf = (ChainElementIf)chainElement;
            EnumSet<ConditionSanitizationResult> sanitization = EnumSet.noneOf(ConditionSanitizationResult.class);
            Context localContext = this.getLocalContext(true, chainElement == initial.getChainElement(), chain.getOwnerVariable());
            chainElementIf.getOperands(targetVariable.getReference()).stream().filter(operand -> this.ruleStrategy.isSanitized((CtElement)operand, localContext)).forEach(operand -> sanitization.add(this.getConditionSanitizationStatus((CtElement)operand)));
            if (!sanitization.isEmpty()) {
                return this.isAccessibleFromBranches(chainElementIf, initial.getChainElement(), sanitization);
            }
        }
        if (!(chainElement == chain.getFirstChainElement() && chainOfTargetVariable || chainElement instanceof ChainElementIf)) {
            return !this.shouldContinueTraverse(chainElement, targetVariable, chain, parentChains, initial);
        }
        return false;
    }

    protected Context getLocalContext(final boolean isCondition, final boolean isStartElement, final @Nullable Variable currentVariable) {
        return new Context(){

            @Override
            public boolean isStartOfVariableTraverse() {
                return isStartElement;
            }

            @Override
            public boolean isAccessedBranchCondition() {
                return isCondition;
            }

            @Override
            @Nullable
            public CtVariableReference<?> getCurrentVariable() {
                return currentVariable != null ? currentVariable.getReference() : null;
            }
        };
    }

    protected boolean isSource(CtElement element) {
        if (element instanceof CtParameterReference && this.currentCallSite.getDepth() != 0) {
            return false;
        }
        return this.ruleStrategy.isSource(element, this.currentCallSite.getExecutableFromCall());
    }

    private boolean shouldContinueTraverse(ChainElement chainElement, Variable targetVariable, DefUseChain chain, Map<DefUseChain, Usage> parentChains, Usage initial) {
        List<CtVariableAccess<?>> usages;
        List<CtVariableAccess<?>> list = usages = chainElement == initial.getChainElement() ? initial.getVariableAccess() : chainElement.getVariableUsages(targetVariable);
        if (chain.getOwnerVariable() != targetVariable) {
            usages.addAll(chainElement.getVariableUsages(chain.getOwnerVariable()));
        }
        if (usages.isEmpty()) {
            return true;
        }
        CtElement borderStatement = chainElement.getElement();
        MutableBoolean accessedToBorder = new MutableBoolean(false);
        LinkedList elementsToScan = new LinkedList(usages);
        do {
            BranchProcessor processor = BranchProcessorFactory.getProcessor(chainElement, initial.getChainElement(), chain);
            elementsToScan.forEach(usage -> this.scanUsage((CtElement)usage, targetVariable, borderStatement, accessedToBorder, processor, parentChains, initial.getChainElement() == chainElement));
            elementsToScan.clear();
            elementsToScan.addAll(processor.getElementsToContinue());
        } while (accessedToBorder.isFalse() && !elementsToScan.isEmpty());
        parentChains.remove(chain);
        return accessedToBorder.getValue();
    }

    private void scanUsage(CtElement usage, final Variable targetVariable, final CtElement borderStatement, final MutableBoolean accessedToBorder, final BranchProcessor branchProcessor, final Map<DefUseChain, Usage> parentChains, final boolean areInitialForVariable) {
        ReverseBorderedScanner reverseScanner = new ReverseBorderedScanner(borderStatement){

            @Override
            public <T> void visitCtInvocation(CtInvocation<T> ctInvocation) {
                if (TaintWalker.this.ruleStrategy.isPushingCollectionMethod(ctInvocation) && targetVariable.equals(VariableFactory.parseFromAst((CtElement)ctInvocation.getTarget()))) {
                    ctInvocation.getArguments().forEach(arg -> parentChains.putAll(TaintWalker.this.getFromInitial((CtElement)arg)));
                }
                if (areInitialForVariable && !this.isInCondition((CtElement)ctInvocation)) {
                    accessedToBorder.setTrue();
                    return;
                }
                super.visitCtInvocation(ctInvocation);
            }

            @Override
            public <T> void visitCtConditional(CtConditional<T> ctConditional) {
                if (branchProcessor.onVisitCtConditional(this.getPreviousElement(), ctConditional)) {
                    super.visitCtConditional(ctConditional);
                }
            }

            @Override
            public void scan(CtElement element) {
                if (element != null) {
                    boolean inConditionFlag = this.isInCondition(element);
                    Context localContext = TaintWalker.this.getLocalContext(inConditionFlag, areInitialForVariable, targetVariable);
                    if (TaintWalker.this.ruleStrategy.isSanitized(element, localContext) || TaintWalker.this.ruleStrategy.isCommonSanitization(element) && inConditionFlag) {
                        branchProcessor.processSanitizedElement(element, borderStatement);
                        return;
                    }
                    if (TaintWalker.this.isSource(element) && !TaintWalker.this.ruleStrategy.isSourceFirstElementsOnly()) {
                        TaintWalker.this.addSource(element);
                        return;
                    }
                    super.scan(element);
                }
            }

            private boolean isInCondition(CtElement element) {
                Pair<CtConditional<?>, CtRole> conditionDetected = BranchContainer.detectCtCondition(element, borderStatement);
                if (conditionDetected.getRight() != null) {
                    return branchProcessor instanceof NormalBranchProcessor && CtRole.CONDITION.equals(conditionDetected.getRight());
                }
                return false;
            }
        };
        reverseScanner.scan(usage);
        if (accessedToBorder.isFalse()) {
            accessedToBorder.setValue(reverseScanner.isAccessedToBorder());
        }
    }

    private boolean isAccessibleFromBranches(ChainElementIf chainElement, ChainElement initial, EnumSet<ConditionSanitizationResult> sanitization) {
        EnumSet<FlowResult> relation = GraphUtils.getNodeRelationToIf(initial, chainElement, this.graphProvider.getControlFlowGraph());
        if (relation.contains((Object)FlowResult.ELSE) && sanitization.contains((Object)ConditionSanitizationResult.THEN) || relation.contains((Object)FlowResult.THEN) && sanitization.contains((Object)ConditionSanitizationResult.ELSE)) {
            return true;
        }
        if (relation.contains((Object)FlowResult.THEN_ACCESSIBLE) && relation.contains((Object)FlowResult.ELSE_ACCESSIBLE)) {
            return false;
        }
        return relation.contains((Object)FlowResult.THEN_ACCESSIBLE) && sanitization.contains((Object)ConditionSanitizationResult.ELSE) || relation.contains((Object)FlowResult.ELSE_ACCESSIBLE) && sanitization.contains((Object)ConditionSanitizationResult.THEN);
    }

    private boolean areAccessible(ChainElement el, ChainElement initial) {
        if (el.getElement() == null || initial.getElement() == null) {
            return true;
        }
        List<BranchCondition> els1 = this.getConditions(el.getElement());
        List<BranchCondition> els2 = this.getConditions(initial.getElement());
        for (BranchCondition src : els1) {
            for (BranchCondition sink : els2) {
                if (!src.areConditionsContradictory(sink)) continue;
                return false;
            }
        }
        return true;
    }

    private List<BranchCondition> getConditions(CtElement el) {
        LinkedList<BranchCondition> conditions = new LinkedList<BranchCondition>();
        CtElement e = el;
        CtRole role = el.getRoleInParent();
        while (!(e.getParent() instanceof CtExecutable)) {
            if (e instanceof CtIf) {
                boolean inElse = role == CtRole.ELSE;
                ContradictionHelper.collectAtoms(((CtIf)e).getCondition(), conditions, inElse, this.graphProvider.getDefUseGraph());
            }
            role = e.getRoleInParent();
            e = e.getParent();
        }
        return conditions;
    }

    private void createCallSites(CtElement el, CallSite<?> curCallSite) {
        final CallSite<?> finalCurrentCallSite = curCallSite;
        if (!(el instanceof CtParameterReference)) {
            CtScanner scanner = new CtScanner(){

                public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                    TaintWalker.this.pushInvocationCall((CtAbstractInvocation<?>)invocation, finalCurrentCallSite);
                }
            };
            scanner.scan(el);
            return;
        }
        CtParameterReference parameter = (CtParameterReference)el;
        Variable abstractParameter = VariableFactory.parseFromAst((CtElement)parameter);
        if (this.fieldHolder.doesVariableHaveFields(abstractParameter)) {
            this.fieldHolder.removeVariable(abstractParameter);
            return;
        }
        CtExecutable<?> executable = curCallSite.getExecutableFromCall();
        int parameterIndex = executable.getParameters().stream().map(CtParameter::getReference).collect(Collectors.toList()).indexOf(parameter);
        if (parameterIndex < 0) {
            return;
        }
        this.cache.addOutgoingParameter(parameter, executable);
        curCallSite = CallSiteSequenceController.getUnprocessedCallSite(curCallSite);
        if (curCallSite instanceof InvocationCall) {
            InvocationCall invocationCall = (InvocationCall)curCallSite;
            CtAbstractInvocation invocation = (CtAbstractInvocation)invocationCall.get();
            CtExecutable exe = (CtExecutable)invocation.getParent(CtExecutable.class);
            this.callSites.add(new ExecutableReturn(invocationCall, exe, parameterIndex));
        } else {
            this.graphProvider.getCallGraph().getCallers(executable).stream().map(x -> new ExecutableCall(this.currentCallSite, (CtExecutable<?>)x, parameterIndex)).filter(CallSiteSequenceController::isNotRecursion).forEach(this.callSites::add);
        }
    }

    protected boolean pushInvocationCall(CtAbstractInvocation<?> invocation, CallSite<?> currentCallSite) {
        if (this.ruleStrategy.isSink((CtElement)invocation)) {
            return false;
        }
        InvocationCall call = InvocationCall.createInvocationCall(invocation, currentCallSite);
        if (call == null) {
            return false;
        }
        if (CallSiteSequenceController.isNotRecursion(call)) {
            this.callSites.add(call);
            this.cache.addConnection(call);
        }
        return true;
    }

    private ConditionSanitizationResult getConditionSanitizationStatus(CtElement operand) {
        int reverseBlackListCommonSanitizationMark;
        CtElement el = operand;
        int notCount = 0;
        while (!(el instanceof CtIf)) {
            if (el instanceof CtUnaryOperator && ((CtUnaryOperator)el).getKind() == UnaryOperatorKind.NOT) {
                ++notCount;
            }
            el = el.getParent();
        }
        Optional<CtBinaryOperator> operator = Optional.of(operand).stream().filter(CtVariableRead.class::isInstance).map(CtElement::getParent).filter(CtBinaryOperator.class::isInstance).map(parent -> (CtBinaryOperator)parent).findFirst();
        int blackListCommonSanitizationMark = this.ruleStrategy.isBlackListCommonSanitization(operand) ? 0 : 1;
        int n = reverseBlackListCommonSanitizationMark = this.ruleStrategy.isBlackListCommonSanitization(operand) ? 1 : 0;
        if (operator.isPresent()) {
            if (operator.get().getKind() == BinaryOperatorKind.EQ) {
                return notCount % 2 == blackListCommonSanitizationMark ? ConditionSanitizationResult.THEN : ConditionSanitizationResult.ELSE;
            }
            return notCount % 2 == reverseBlackListCommonSanitizationMark ? ConditionSanitizationResult.THEN : ConditionSanitizationResult.ELSE;
        }
        if (this.ruleStrategy.isCommonSanitization(operand)) {
            return notCount % 2 == blackListCommonSanitizationMark ? ConditionSanitizationResult.THEN : ConditionSanitizationResult.ELSE;
        }
        return notCount % 2 == (this.ruleStrategy.isBranchDirectionReversed(operand) ? 1 : 0) ? ConditionSanitizationResult.THEN : ConditionSanitizationResult.ELSE;
    }

    protected boolean isTargetType(CtVariableAccess<?> variable) {
        return this.isTargetType(variable.getType());
    }

    protected boolean isTargetType(CtTypeReference<?> type) {
        return !(this.ruleStrategy.isStringsOnly() && !this.isStringType(type) || type != null && this.ruleStrategy.isTypeIgnored(type));
    }

    private boolean isStringType(CtTypeReference<?> reference) {
        if (reference == null) {
            return false;
        }
        String[] stringTypes = new String[]{"java.lang.String", "java.lang.CharSequence"};
        if (reference.isArray()) {
            reference = ((CtArrayTypeReference)reference).getArrayType();
        }
        CtTypeReference finalReference = reference;
        return Arrays.stream(stringTypes).anyMatch(typeName -> finalReference.getQualifiedName().equals(typeName));
    }

    private void addConcatFlag(Usage initial) {
        for (CtVariableAccess<?> usage : initial.getVariableAccess()) {
            if (!(usage.getParent(CtStatement.class) instanceof CtOperatorAssignment || usage.getRoleInParent() == CtRole.TARGET && usage.getParent() instanceof CtArrayRead && usage.getParent().getRoleInParent() == CtRole.RIGHT_OPERAND || usage.getRoleInParent() == CtRole.RIGHT_OPERAND || usage.getRoleInParent() == CtRole.ARGUMENT && this.ruleStrategy.isStringConcatenationMethod((CtInvocation)usage.getParent(CtInvocation.class))) && (!(usage.getParent() instanceof CtNewArray) || ((CtNewArray)usage.getParent()).getElements().indexOf(usage) == 0)) continue;
            this.path.addFlag(this.currentCallSite.getExecutableFromCall(), TaintFlag.RIGHT_PART_OF_CONCAT);
        }
    }

    protected void addSource(CtElement el) {
        CtExecutable<?> method = this.currentCallSite.getExecutableFromCall();
        this.sources.add(TaintSource.createFromElement(el, method));
        this.cache.addSource(el);
        this.path.addFlag(method, TaintFlag.CONTAINS_SOURCE);
        this.path.markIncomingWithFlag(method, TaintFlag.LEADS_TO_SOURCE);
    }

    public List<IntermediateCallSite<?>> resetCallSites() {
        List<IntermediateCallSite<?>> memory = this.callSites;
        this.callSites = new LinkedList();
        return memory;
    }

    public List<TaintSource> resetSources() {
        List<TaintSource> memory = this.sources;
        this.sources = new LinkedList<TaintSource>();
        return memory;
    }
}

