/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.graph.GraphModel;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import com.pvsstudio.dataflow.interprocedural.Parameterized;
import com.pvsstudio.dataflow.interprocedural.StartCall;
import com.pvsstudio.dataflow.interprocedural.strategy.CallSiteStrategy;
import com.pvsstudio.dataflow.interprocedural.strategy.ExecutableCallStrategy;
import com.pvsstudio.dataflow.interprocedural.strategy.InvocationCallStrategy;
import com.pvsstudio.dataflow.interprocedural.strategy.StartCallStrategy;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import com.pvsstudio.dataflow.taint.GraphProvider;
import com.pvsstudio.dataflow.taint.TaintFlag;
import com.pvsstudio.dataflow.taint.TaintPath;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.TaintSource;
import com.pvsstudio.dataflow.taint.TaintWalker;
import com.pvsstudio.dataflow.taint.cache.TaintCacheController;
import com.pvsstudio.dataflow.taint.cache.VisitedCallsController;
import com.pvsstudio.dataflow.taint.cache.rule.TaintByRuleCache;
import com.pvsstudio.dataflow.taint.sink.Sink;
import com.pvsstudio.dataflow.taint.sink.SinkScanner;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintPrinter;
import com.pvsstudio.timeout.TimeoutChecker;
import com.pvsstudio.timeout.TimeoutCheckerFactory;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;

public class TaintSupervisor {
    private static final Logger logger = LoggerFactory.getLogger(TaintSupervisor.class);
    private static final int MAX_INTERPROCEDURAL_STEPS = 1000;
    private static final int MAX_CALLS = 1000;
    private final GraphProvider graphProvider;
    private final AnnotationSetter annotationSetter;
    private final TaintPrinter printer;
    private final TimeoutCheckerFactory timeoutCheckerFactory;
    private final TaintRuleStrategy ruleStrategy;
    private final TaintCacheController cacheController;
    private TaintPath<CtExecutable<?>> path;
    private VisitedCallsController callsController;
    private TaintWalker walker;

    public TaintSupervisor(GraphModel graph, AnnotationSetter annotationSetter, TaintPrinter printer, TimeoutCheckerFactory timeoutCheckerFactory, TaintRuleStrategy ruleStrategy, TaintByRuleCache cache) {
        this.graphProvider = new GraphProvider(graph);
        this.annotationSetter = annotationSetter;
        this.printer = printer;
        this.timeoutCheckerFactory = timeoutCheckerFactory;
        this.ruleStrategy = ruleStrategy;
        this.cacheController = new TaintCacheController(cache);
    }

    public List<TaintResult> scanTaint(CtElement element, CtExecutable<?> curExecutable) {
        logger.debug("{} -> Start taint-analysis of '{}' executable of '{}'", new Object[]{Thread.currentThread().getName(), curExecutable.getSimpleName(), element});
        LinkedList<TaintResult> results = new LinkedList<TaintResult>();
        for (Sink sink : new SinkScanner(this.ruleStrategy, element).findSinks()) {
            this.path = new TaintPath(curExecutable);
            this.walker = new TaintWalker(this.ruleStrategy, this.graphProvider, this.path, this.cacheController);
            this.callsController = new VisitedCallsController();
            LinkedList<TaintSource> foundedSources = new LinkedList<TaintSource>();
            StartCall startCall = new StartCall(curExecutable, sink.getSinkTreeElement());
            this.processCallSiteByWalker(startCall, sink, foundedSources);
            List<IntermediateCallSite<?>> newCallSites = new LinkedList(this.walker.resetCallSites());
            TimeoutChecker timeoutChecker = this.timeoutCheckerFactory.timeoutCheckerWithCurrentTimestamp();
            int step = 0;
            do {
                timeoutChecker.assertNotTimeout();
                if (++step > 1000 || newCallSites.size() > 1000) {
                    logger.debug("{} -> The maximum limit of interprocedural taint analysis calls has been overflowed.", (Object)Thread.currentThread().getName());
                    break;
                }
                List<IntermediateCallSite<?>> sortedCallSites = this.sort(newCallSites);
                this.doWalk(sink, sortedCallSites, foundedSources);
            } while (!(newCallSites = this.walker.resetCallSites()).isEmpty());
            TaintResult result = new TaintResult(sink, foundedSources);
            TaintPath.TaintedIterator iterator = this.path.createIterator();
            while (iterator.hasNext()) {
                CtExecutable node = (CtExecutable)iterator.next();
                if (!this.path.hasBeenTraversedWithFlag(node, TaintFlag.RIGHT_PART_OF_CONCAT)) continue;
                result.addFlag(TaintFlag.RIGHT_PART_OF_CONCAT);
            }
            results.add(result);
        }
        return results;
    }

    private void doWalk(Sink sink, List<IntermediateCallSite<?>> calls, List<TaintSource> foundedSources) {
        for (IntermediateCallSite<?> call : calls) {
            CtExecutable<?> curExecutable = call.getExecutableFromCall();
            this.annotationSetter.processAnnotations(curExecutable);
            if (!(call instanceof ExecutableReturn)) {
                this.path.connect(call.getParent().getExecutableFromCall(), curExecutable, call.getInterproceduralTraverseDirection(), call instanceof Parameterized ? Integer.valueOf(((Parameterized)((Object)call)).getParameterPos()) : null);
            }
            this.processCallSiteByWalker(call, sink, foundedSources);
        }
    }

    private void processCallSiteByWalker(CallSite<?> callSite, Sink sink, List<TaintSource> foundedSources) {
        this.walker.walk(this.getCallSiteStrategy(callSite, sink));
        this.walker.resetSources().forEach(s -> {
            this.printer.print(s.getElement(), callSite);
            foundedSources.add((TaintSource)s);
        });
    }

    private List<IntermediateCallSite<?>> sort(List<IntermediateCallSite<?>> callSites) {
        return callSites.stream().sorted(((Comparator)this::compareTypes).thenComparing(cs -> cs.getSignature().toString()).thenComparingInt(cs -> cs instanceof Parameterized ? ((Parameterized)((Object)cs)).getParameterPos() : 0)).collect(Collectors.toList());
    }

    private int compareTypes(IntermediateCallSite<?> first, IntermediateCallSite<?> second) {
        if (first.getClass() == second.getClass()) {
            return 0;
        }
        if (first instanceof InvocationCall) {
            return -1;
        }
        if (second instanceof InvocationCall) {
            return 1;
        }
        return first instanceof ExecutableReturn ? -1 : 1;
    }

    private CallSiteStrategy<?> getCallSiteStrategy(CallSite<?> callSite, Sink sink) {
        if (callSite instanceof StartCall) {
            return new StartCallStrategy((StartCall)callSite, sink);
        }
        if (callSite instanceof InvocationCall) {
            return new InvocationCallStrategy((InvocationCall)callSite);
        }
        if (callSite instanceof ExecutableCall) {
            return new ExecutableCallStrategy((ExecutableCall)callSite, this.callsController, this.graphProvider);
        }
        throw new IllegalArgumentException("unexpected type of callSite, got: " + callSite.getClass().getName());
    }
}

