/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class TaintScanner
extends CtScanner {
    private CtRole conditionRole;

    public final boolean scanReturnedArgument(CtAbstractInvocation<?> invocation, ExecutableCall currentCallSite) {
        if (Optional.of(currentCallSite.getParent()).map(CallSite::getExecutableFromCall).filter(e -> e.getReference().equals((Object)invocation.getExecutable())).isPresent()) {
            if (invocation.getArguments().size() > currentCallSite.getParameterPos()) {
                this.scan(CtRole.ARGUMENT, (CtElement)invocation.getArguments().get(currentCallSite.getParameterPos()));
            }
            return true;
        }
        return false;
    }

    public void scanTarget(CtInvocation<?> inv, Predicate<CtTypeReference<?>> typeChecker) {
        if (inv.getTarget() != null && typeChecker.test(inv.getTarget().getType()) || inv.getArguments().isEmpty()) {
            this.scan(CtRole.TARGET, (CtElement)inv.getTarget());
        }
    }

    public void scan(@Nullable ChainElement chainElement) {
        if (chainElement != null) {
            this.scan(chainElement.getElement());
        }
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtRole memory = this.conditionRole;
        this.conditionRole = CtRole.CONDITION;
        super.scan((CtElement)conditional.getCondition());
        this.conditionRole = CtRole.THEN;
        super.scan((CtElement)conditional.getThenExpression());
        this.conditionRole = CtRole.ELSE;
        super.scan((CtElement)conditional.getElseExpression());
        this.conditionRole = memory;
    }

    @Nullable
    public final CtRole getConditionRole() {
        return this.conditionRole;
    }

    public final <T> void visitCtLambda(CtLambda<T> lambda) {
    }

    public final <T> void visitCtNewClass(CtNewClass<T> newClass) {
    }
}

