/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.taint.TaintFlag;
import com.pvsstudio.dataflow.taint.TaintSource;
import com.pvsstudio.dataflow.taint.sink.Sink;
import java.util.EnumSet;
import java.util.List;
import spoon.reflect.declaration.CtElement;

public class TaintResult {
    private final EnumSet<TaintFlag> flags = EnumSet.noneOf(TaintFlag.class);
    private final List<TaintSource> sources;
    private final Sink sink;

    public TaintResult(Sink sink, List<TaintSource> sources) {
        this.sink = sink;
        this.sources = sources;
    }

    public void addFlag(TaintFlag flag) {
        this.flags.add(flag);
    }

    public CtElement getSinkElement() {
        return this.sink.getSinkTreeElement();
    }

    public boolean isTainted() {
        return !this.sources.isEmpty();
    }

    public List<TaintSource> getSources() {
        return this.sources;
    }

    public boolean hasFlag(TaintFlag flag) {
        return this.flags.contains((Object)flag);
    }
}

