/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.taint;

import com.pvsstudio.dataflow.graph.SimpleEdge;
import com.pvsstudio.dataflow.taint.InterproceduralTraverseDirection;
import com.pvsstudio.dataflow.taint.TaintFlag;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.graph.DefaultDirectedGraph;
import spoon.reflect.declaration.CtExecutable;

public class TaintPath<T> {
    private final DefaultDirectedGraph<T, Edge> tree = new DefaultDirectedGraph(Edge.class);
    private final Map<T, NodeInfo> nodes = new IdentityHashMap<T, NodeInfo>();
    private final T start;

    public TaintPath(T start) {
        this.start = start;
        this.tree.addVertex(start);
        this.nodes.put(start, new NodeInfo());
    }

    public void connect(T from, T to, InterproceduralTraverseDirection flag, Integer argumentNumber) {
        if (!this.nodes.containsKey(to)) {
            this.nodes.put(to, new NodeInfo());
            this.tree.addVertex(to);
        }
        this.nodes.get(to).addArgumentFlag(argumentNumber, flag);
        if (this.tree.containsVertex(from)) {
            this.tree.addEdge(from, to);
        }
    }

    public boolean hasBeenTraversedWithArgumentFlag(T node, InterproceduralTraverseDirection flag) {
        return this.hasBeenTraversedWithArgumentFlag(node, null, flag);
    }

    public boolean hasBeenTraversedWithArgumentFlag(T node, @Nullable Integer argumentNumber, InterproceduralTraverseDirection flag) {
        NodeInfo meta = this.nodes.get(node);
        if (meta != null && flag != null) {
            return meta.hasArgumentFlag(argumentNumber, flag);
        }
        return false;
    }

    public void markIncomingWithFlag(T node, TaintFlag flag) {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        LinkedList toTraverse = new LinkedList();
        toTraverse.add(node);
        while (!toTraverse.isEmpty()) {
            Object vertex = toTraverse.poll();
            for (Edge edge : this.tree.incomingEdgesOf(vertex)) {
                Object src = edge.getSourceNode();
                if (this.hasBeenTraversedWithFlag(src, flag) || visited.contains(src)) continue;
                toTraverse.add(src);
                this.addFlag(src, flag);
            }
        }
    }

    public boolean hasBeenTraversedWithFlag(T node, TaintFlag flag) {
        return this.nodes.containsKey(node) && this.nodes.get(node).hasFlag(flag);
    }

    public void addFlag(T node, @Nullable TaintFlag flag) {
        if (flag == null) {
            return;
        }
        if (!this.nodes.containsKey(node)) {
            throw new RuntimeException("Node doesn't exist in graph");
        }
        this.nodes.get(node).addFlag(flag);
    }

    public TaintedIterator createIterator() {
        return new TaintedIterator(this.start);
    }

    private static class Edge
    extends SimpleEdge<CtExecutable<?>> {
        private Edge() {
        }
    }

    private static class NodeInfo {
        Map<Integer, EnumSet<InterproceduralTraverseDirection>> arguments = new IdentityHashMap<Integer, EnumSet<InterproceduralTraverseDirection>>();
        EnumSet<TaintFlag> flags = EnumSet.noneOf(TaintFlag.class);

        private NodeInfo() {
        }

        public void addArgumentFlag(@Nullable Integer parameter, InterproceduralTraverseDirection flag) {
            if (!this.arguments.containsKey(parameter)) {
                this.arguments.put(parameter, EnumSet.of(flag));
            } else {
                this.arguments.get(parameter).add(flag);
            }
        }

        public void addFlag(TaintFlag flag) {
            this.flags.add(flag);
        }

        public boolean hasFlag(TaintFlag flag) {
            return this.flags.contains((Object)flag);
        }

        public boolean hasArgumentFlag(@Nullable Integer parameter, InterproceduralTraverseDirection flag) {
            if (!this.arguments.containsKey(parameter)) {
                return false;
            }
            return this.arguments.get(parameter).contains((Object)flag);
        }
    }

    public class TaintedIterator
    implements Iterator<T> {
        private final Queue<T> queue = new LinkedList();
        private final Set<T> queuedNodes = new HashSet();

        private TaintedIterator(T initial) {
            this.queue.add(initial);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            Object node = this.queue.remove();
            for (Edge edge : TaintPath.this.tree.outgoingEdgesOf(node)) {
                Object target = edge.getTargetNode();
                if (!TaintPath.this.nodes.containsKey(target) || !TaintPath.this.nodes.get(target).hasFlag(TaintFlag.LEADS_TO_SOURCE) && !TaintPath.this.nodes.get(target).hasFlag(TaintFlag.CONTAINS_SOURCE) || this.queuedNodes.contains(target)) continue;
                this.queue.add(target);
                this.queuedNodes.add(target);
            }
            return node;
        }
    }
}

