/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.java;

import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.taint.iterator.SimpleDFSIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtVariableReference;

public abstract class UsageVisitor {
    private boolean globalTerminateFlag = false;
    private boolean terminateFlag = false;
    private Variable currentVariable = null;

    public abstract void visitUsage(CtElement var1);

    public abstract void visitDefaultExpression(CtElement var1);

    public final CtVariableReference<?> getCurrentVariable() {
        return this.currentVariable.getReference();
    }

    public final void terminateAllScan() {
        this.globalTerminateFlag = true;
    }

    public final void terminateScanCurrentChain() {
        this.terminateFlag = true;
    }

    protected final void scan(DefUseGraph graph, CtElement initialElement, CtVariableAccess<?> variable) {
        Map<DefUseChain, ChainElement> chainsToIterate = new LinkedHashMap<DefUseChain, ChainElement>();
        this.fillChainsMap(chainsToIterate, graph.getChains(variable), initialElement);
        chainsToIterate = this.sort(chainsToIterate);
        this.globalTerminateFlag = false;
        while (!chainsToIterate.isEmpty()) {
            LinkedHashMap<DefUseChain, ChainElement> parentChains = new LinkedHashMap<DefUseChain, ChainElement>();
            for (Map.Entry<DefUseChain, ChainElement> entry : chainsToIterate.entrySet()) {
                if (this.globalTerminateFlag) continue;
                this.scanChain(entry.getKey(), entry.getValue(), parentChains);
            }
            if (this.globalTerminateFlag) break;
            chainsToIterate = this.sort(parentChains);
        }
    }

    private Map<DefUseChain, ChainElement> sort(Map<DefUseChain, ChainElement> chains) {
        ArrayList<Map.Entry<DefUseChain, ChainElement>> entries = new ArrayList<Map.Entry<DefUseChain, ChainElement>>(chains.entrySet());
        entries.sort((first, second) -> {
            DefUseChain firstChain = (DefUseChain)first.getKey();
            DefUseChain secondChain = (DefUseChain)second.getKey();
            SourcePosition firstChainElement = firstChain.getDefaultExpression() != null ? firstChain.getDefaultExpression().getPosition() : firstChain.getOwnerVariable().getPosition();
            SourcePosition secondChainElement = secondChain.getDefaultExpression() != null ? secondChain.getDefaultExpression().getPosition() : secondChain.getOwnerVariable().getPosition();
            int firstLine = firstChainElement.getLine();
            int secondLine = secondChainElement.getLine();
            return secondLine - firstLine;
        });
        LinkedHashMap<DefUseChain, ChainElement> sortedMap = new LinkedHashMap<DefUseChain, ChainElement>();
        for (Map.Entry entry : entries) {
            sortedMap.put((DefUseChain)entry.getKey(), (ChainElement)entry.getValue());
        }
        return sortedMap;
    }

    private void fillChainsMap(Map<DefUseChain, ChainElement> chains, Collection<DefUseChain> chainList, CtElement initialElement) {
        if (initialElement == null) {
            return;
        }
        for (DefUseChain chain : chainList) {
            ChainElement element = chain.find(initialElement);
            if (element == null) continue;
            chains.put(chain, element);
        }
    }

    private void scanChain(DefUseChain chain, ChainElement initial, Map<DefUseChain, ChainElement> parentChains) {
        SimpleDFSIterator iterator = new SimpleDFSIterator(chain, initial);
        ChainElement firstElement = chain.getFirstChainElement();
        this.terminateFlag = false;
        this.currentVariable = chain.getOwnerVariable();
        while (iterator.hasNext()) {
            ChainElement currentElement = iterator.next();
            if (currentElement != firstElement) {
                this.visitUsage(currentElement.getElement());
            } else {
                this.visitDefaultExpression((CtElement)(chain.getDefaultExpression() == null ? chain.getOwnerVariable().getReference() : chain.getDefaultExpression()));
            }
            if (this.terminateFlag || this.globalTerminateFlag) {
                return;
            }
            if (currentElement != firstElement) continue;
            this.fillChainsMap(parentChains, chain.getParents(), firstElement.getElement());
        }
    }
}

