/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.java;

import com.google.inject.Inject;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.graph.GraphModel;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.java.UsageVisitor;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.TaintSupervisor;
import com.pvsstudio.dataflow.taint.cache.TaintCache;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintPrinter;
import com.pvsstudio.dataflow.traversal.CFGMethodInvocationChecker;
import com.pvsstudio.dataflow.utility.InvocationWrapper;
import com.pvsstudio.timeout.TimeoutCheckerFactory;
import fr.inria.controlflow.ControlFlowNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.reflect.visitor.filter.VariableAccessFilter;

public class DataFlowImpl
implements DataFlow {
    private GraphModel graphModel;
    private final AnnotationSetter annotationSetter;
    private final TaintCache taintCache;
    private final TaintPrinter printer;
    private final TimeoutCheckerFactory timeoutCheckerFactory;

    @Inject
    public DataFlowImpl(@NotNull AnnotationSetter annotationSetter, @NotNull TaintCache taintCache, @NotNull TaintPrinter printer, @NotNull TimeoutCheckerFactory timeoutCheckerFactory) {
        this.annotationSetter = annotationSetter;
        this.taintCache = taintCache;
        this.printer = printer;
        this.timeoutCheckerFactory = timeoutCheckerFactory;
    }

    @Override
    public void setGraphModel(GraphModel model) {
        this.graphModel = model;
    }

    @Override
    public List<CtElement> getAllDefaultExpressions(CtVariableAccess<?> reference) {
        CtExecutable executable = (CtExecutable)reference.getParent(CtExecutable.class);
        if (executable == null) {
            return Collections.emptyList();
        }
        DefUseGraph graph = this.graphModel.getDefUseGraph(executable);
        if (graph == null) {
            return Collections.emptyList();
        }
        List<DefUseChain> chains = graph.getChains(reference);
        LinkedList<CtElement> defaultExpressions = new LinkedList<CtElement>();
        for (DefUseChain chain : chains) {
            CtElement defaultExpression = chain.getDefaultExpression();
            if (defaultExpression == null) continue;
            defaultExpressions.add(defaultExpression);
        }
        return defaultExpressions;
    }

    @Override
    public double evaluateDouble(CtExpression<?> expression) {
        CtExecutable executable = (CtExecutable)expression.getParent(CtExecutable.class);
        if (executable == null) {
            return Double.NaN;
        }
        DefUseGraph graph = this.graphModel.getDefUseGraph(executable);
        if (graph == null) {
            return Double.NaN;
        }
        return this.evaluateDouble(expression, graph);
    }

    public double evaluateDouble(CtExpression<?> expression, DefUseGraph graph) {
        expression = (CtExpression)expression.partiallyEvaluate();
        Optional<Double> doubleOptional = Optional.of(expression).filter(x -> x instanceof CtLiteral).map(x -> (CtLiteral)x).map(CtLiteral::getValue).filter(Number.class::isInstance).map(x -> (Number)x).map(Number::doubleValue);
        if (doubleOptional.isPresent()) {
            return doubleOptional.get();
        }
        if (expression instanceof CtUnaryOperator) {
            CtUnaryOperator unaryOperator = (CtUnaryOperator)expression;
            double value = this.evaluateDouble(unaryOperator.getOperand());
            if (Double.isNaN(value)) {
                return value;
            }
            switch (unaryOperator.getKind()) {
                case NEG: {
                    return -value;
                }
                case PREDEC: {
                    return value - 1.0;
                }
                case PREINC: {
                    return value + 1.0;
                }
            }
            return value;
        }
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator operator = (CtBinaryOperator)expression;
            double first = this.evaluateDouble(operator.getLeftHandOperand(), graph);
            double second = this.evaluateDouble(operator.getRightHandOperand(), graph);
            switch (operator.getKind()) {
                case PLUS: {
                    return first + second;
                }
                case MINUS: {
                    return first - second;
                }
                case MUL: {
                    if (Math.abs(first) < Double.MIN_VALUE || Math.abs(second) < Double.MIN_VALUE) {
                        return 0.0;
                    }
                    return first * second;
                }
            }
            return Double.NaN;
        }
        if (expression instanceof CtVariableAccess) {
            List<DefUseChain> chains = graph.getChains((CtVariableAccess)expression);
            if (chains.size() != 1) {
                return Double.NaN;
            }
            CtElement defaultExpression = chains.get(0).getDefaultExpression();
            if (defaultExpression instanceof CtExpression) {
                return this.evaluateDouble((CtExpression)defaultExpression, graph);
            }
        }
        return Double.NaN;
    }

    @Override
    public void scanUsages(CtElement el, CtVariableAccess<?> variable, UsageVisitor visitor) {
        CtExecutable executable = (CtExecutable)variable.getParent(CtExecutable.class);
        DefUseGraph defUseGraph = this.graphModel.getDefUseGraph(executable);
        if (defUseGraph != null) {
            visitor.scan(defUseGraph, el, variable);
        }
    }

    @Override
    public List<TaintResult> scanTaint(CtElement el, TaintRuleStrategy ruleStrategy, Class<?> ruleClass) {
        CtExecutable executable = (CtExecutable)el.getParent(CtExecutable.class);
        CtNewClass potentialNewClass = (CtNewClass)el.getParent(CtNewClass.class);
        if (executable == null || executable instanceof CtLambda || potentialNewClass != null) {
            return null;
        }
        return new TaintSupervisor(this.graphModel, this.annotationSetter, this.printer, this.timeoutCheckerFactory, ruleStrategy, this.taintCache.byRule(ruleClass)).scanTaint(el, executable);
    }

    @Override
    public List<CtElement> getVariableUsages(@NotNull CtElement variable, @Nullable CtElement expression) {
        if (!(variable instanceof CtVariable || variable instanceof CtVariableAccess || variable instanceof CtVariableReference)) {
            throw new IllegalArgumentException("variable is not CtVariable or CtVariableAccess");
        }
        Variable abstractVariable = VariableFactory.parseFromAst(variable);
        return abstractVariable != null ? this.getVariableUsages(abstractVariable, expression) : Collections.emptyList();
    }

    public List<CtElement> getVariableUsages(@NotNull Variable variable, @Nullable CtElement expression) {
        ArrayList<CtElement> usages = new ArrayList<CtElement>();
        CtExecutable method = (CtExecutable)variable.getReference().getParent(CtExecutable.class);
        DefUseGraph du = this.graphModel.getDefUseGraph(method);
        if (du == null) {
            return Collections.emptyList();
        }
        List<DefUseChain> chains = du.getChains(variable);
        for (DefUseChain chain : chains) {
            if (chain.getDefaultExpression() != expression) continue;
            usages.addAll(chain.vertexSet().stream().skip(1L).map(ChainElement::getElement).collect(Collectors.toList()));
        }
        return usages;
    }

    @Override
    public Stream<CtElement> getVariableUsages(@NotNull CtVariable<?> variable) {
        CtExecutable executable = (CtExecutable)variable.getParent(CtExecutable.class);
        DefUseGraph du = this.graphModel.getDefUseGraph(executable);
        if (du == null) {
            return Stream.empty();
        }
        return du.getChains(VariableFactory.parseFromAst(variable)).stream().map(Graph::vertexSet).map(Collection::stream).flatMap(stream -> stream.skip(1L)).map(ChainElement::getElement);
    }

    @Override
    @Nullable
    public CtElement getVariableExpression(CtVariableAccess<?> variable, CtElement element) {
        DefUseChain chain = this.getVariableDefUseChain((CtElement)variable, element);
        return chain != null ? chain.getDefaultExpression() : null;
    }

    @Override
    public List<CtElement> getVariableUsageChainWithElement(CtVariableAccess<?> variable, CtElement expectedElement) {
        CtExecutable executable = (CtExecutable)variable.getParent(CtExecutable.class);
        DefUseGraph du = this.graphModel.getDefUseGraph(executable);
        if (du == null) {
            return Collections.emptyList();
        }
        ArrayList<CtElement> usages = new ArrayList<CtElement>();
        List<DefUseChain> chains = du.getChains(variable);
        for (DefUseChain chain : chains) {
            Set vertexSet = chain.vertexSet();
            if (!vertexSet.stream().anyMatch(chainElement -> chainElement.getElement() == expectedElement)) continue;
            for (ChainElement chainElement2 : vertexSet) {
                if (chainElement2.isBegin()) continue;
                usages.add(chainElement2.getElement());
            }
        }
        return usages;
    }

    @Override
    public boolean methodCallsFromAllControlFlowPaths(CtMethod<?> method, CtStatement initStatement, CtVariableReference<?> initElem, List<InvocationWrapper> invWrap, List<InvocationWrapper> invObjPass) {
        return new CFGMethodInvocationChecker(this.graphModel, invWrap, invObjPass).methodCallsFromAllControlFlowPaths(method, initStatement, initElem);
    }

    @Override
    public List<CtVariableAccess<?>> getAllVariableUsages(CtVariableReference<?> reference) {
        DefUseGraph du = this.graphModel.getDefUseGraph((CtExecutable)reference.getParent(CtExecutable.class));
        if (du == null) {
            return Collections.emptyList();
        }
        Variable variable = VariableFactory.parseFromAst(reference);
        LinkedList result = new LinkedList();
        for (DefUseChain chain : du.getChains(variable)) {
            for (ChainElement el : chain.vertexSet()) {
                if (el.isBegin() || el == chain.getFirstChainElement()) continue;
                result.addAll(el.getVariableUsages(variable));
            }
        }
        return result;
    }

    @Override
    public List<CtVariableAccess<?>> getVariableUsagesWithDependencies(CtParameter<?> param, CtMethod<?> method) {
        DefUseGraph du = this.graphModel.getDefUseGraph((CtExecutable<?>)method);
        if (du == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        Variable variable = VariableFactory.parseFromAst(param);
        for (DefUseChain chains : du.getChains(variable)) {
            chains.vertexSet().stream().filter(el -> !el.isBegin() && el.getElement() != null).map(ChainElement::getElement).forEach(el -> el.getElements((Filter)new TypeFilter(CtVariableRead.class)).stream().filter(usage -> variable.equals(VariableFactory.parseFromAst((CtElement)usage))).forEach(result::add));
        }
        List<CtVariableReference<?>> depending = this.getVariablesCreatedByOwner(variable, du);
        depending.forEach(ref -> result.addAll(this.getAllVariableUsages((CtVariableReference<?>)ref)));
        return result;
    }

    private List<CtVariableReference<?>> getVariablesCreatedByOwner(Variable variable, DefUseGraph graph) {
        ArrayList result = new ArrayList();
        ArrayList potentiallyDependingVariables = new ArrayList();
        graph.getChains(variable).forEach(chain -> chain.vertexSet().stream().filter(el -> !el.isBegin() && el.getElement() != null).map(ChainElement::getElement).filter(CtLocalVariable.class::isInstance).map(CtLocalVariable.class::cast).forEach(potentiallyDependingVariables::add));
        for (CtLocalVariable localVariable : potentiallyDependingVariables) {
            List usages = localVariable.getAssignment().getElements((Filter)new TypeFilter(CtVariableRead.class));
            for (CtVariableRead usage : usages) {
                if (!variable.equals(VariableFactory.parseFromAst((CtElement)usage))) continue;
                result.add((CtVariableReference<?>)localVariable.getReference());
            }
        }
        return result;
    }

    @Override
    public int getSameInvocationsCount(CtInvocation<?> invocation) {
        return this.graphModel.getCallGraph().getIncomingEdges(MethodSignature.of(invocation)).size();
    }

    @Override
    public List<CtElement> getReachableUsages(CtElement variableAccess, Predicate<CtVariableReference<?>> filter) {
        Variable abstractVariable = VariableFactory.parseFromAst(variableAccess);
        if (abstractVariable == null) {
            return Collections.emptyList();
        }
        CtMethod method = (CtMethod)variableAccess.getParent(CtMethod.class);
        if (method == null) {
            return Collections.emptyList();
        }
        CtStatement statement = (CtStatement)variableAccess.getParent(CtStatement.class);
        if (statement == null) {
            return Collections.emptyList();
        }
        if (statement.getParent(CtExecutable.class) instanceof CtLambda) {
            return Collections.emptyList();
        }
        if (statement.getParent(CtNewClass.class) != null) {
            return Collections.emptyList();
        }
        DefUseChain variableChain = this.getVariableDefUseChain(variableAccess, variableAccess);
        if (variableChain == null) {
            return Collections.emptyList();
        }
        CtElement defaultExpression = variableChain.getDefaultExpression();
        List<CtElement> usages = this.getVariableUsages(variableAccess, defaultExpression);
        LinkedList<DefUseChain> aliases = new LinkedList<DefUseChain>();
        usages.stream().filter(CtLocalVariable.class::isInstance).map(CtLocalVariable.class::cast).filter(local -> local.getAssignment() instanceof CtVariableRead).forEach(local -> aliases.add(this.getVariableDefUseChain((CtElement)local, (CtElement)local)));
        usages.stream().filter(CtAssignment.class::isInstance).map(CtAssignment.class::cast).filter(assignment -> assignment.getAssignment() instanceof CtVariableRead).filter(assignment -> assignment.getAssigned() instanceof CtVariableAccess).forEach(x -> aliases.add(this.getVariableDefUseChain((CtElement)x.getAssigned(), (CtElement)x)));
        for (DefUseChain alias : aliases) {
            for (CtElement usage2 : this.getVariableUsages(alias.getOwnerVariable(), alias.getDefaultExpression())) {
                if (!usages.stream().noneMatch(u -> u == usage2)) continue;
                usages.add(usage2);
            }
        }
        ChainElement chainElement = variableChain.find(variableAccess);
        if (chainElement == null) {
            throw new PvsStudioException(String.format("Could not find node for element %s", statement));
        }
        ControlFlowNode node = chainElement.getNode();
        ControlFlowNode defaultExpressionNode = variableChain.getFirstChainElement().getNode();
        HashSet nodesAfter = new HashSet();
        ArrayDeque<ControlFlowNode> nodesToVisit = new ArrayDeque<ControlFlowNode>();
        nodesToVisit.add(node);
        while (!nodesToVisit.isEmpty()) {
            List next = ((ControlFlowNode)nodesToVisit.poll()).next();
            for (ControlFlowNode toAdd : next) {
                if (toAdd == defaultExpressionNode || nodesAfter.contains(toAdd)) continue;
                nodesToVisit.add(toAdd);
            }
            nodesAfter.addAll(next);
        }
        List<CtElement> reachableUsages = nodesAfter.stream().map(ControlFlowNode::getStatement).filter(Objects::nonNull).filter(stmt -> usages.stream().anyMatch(usage -> usage == stmt)).collect(Collectors.toList());
        aliases.add(variableChain);
        for (DefUseChain alias : aliases) {
            Iterator iterator = reachableUsages.iterator();
            while (iterator.hasNext()) {
                CtElement reachableUsage = (CtElement)iterator.next();
                CtVariableReference<?> reference = alias.getOwnerVariableReference() instanceof CtParameterReference ? abstractVariable.getReference() : alias.getOwnerVariableReference();
                List variableUsages = reachableUsage.getElements((Filter)new VariableAccessFilter(reference));
                boolean remove = false;
                for (CtVariableAccess variableUsage : variableUsages) {
                    if (filter.test(variableUsage.getVariable())) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                iterator.remove();
            }
        }
        reachableUsages.removeIf(usage -> usage.equals((Object)statement));
        reachableUsages.removeIf(usage -> usage.equals((Object)variableAccess));
        return reachableUsages;
    }

    private DefUseChain getVariableDefUseChain(Variable variable, CtElement element) {
        CtExecutable method = (CtExecutable)element.getParent(CtExecutable.class);
        DefUseGraph du = this.graphModel.getDefUseGraph(method);
        if (du == null || variable == null) {
            return null;
        }
        List<DefUseChain> chains = du.getChains(variable);
        DefUseChain targetChain = null;
        for (DefUseChain chain : chains) {
            ChainElement chainElement = chain.find(element);
            if (chainElement == null) continue;
            targetChain = chain;
            break;
        }
        return targetChain;
    }

    private DefUseChain getVariableDefUseChain(CtElement variable, CtElement element) {
        Variable abstractVariable = VariableFactory.parseFromAst(variable);
        return abstractVariable != null ? this.getVariableDefUseChain(abstractVariable, element) : null;
    }

    @Override
    public boolean containsAnyUsagesAfter(CtVariableAccess<?> variableAccess) {
        Variable variable = VariableFactory.parseFromAst(variableAccess);
        CtExecutable executable = (CtExecutable)variableAccess.getParent(CtExecutable.class);
        if (executable == null || variable == null) {
            return false;
        }
        DefUseGraph du = this.graphModel.getDefUseGraph(executable);
        if (du == null) {
            return false;
        }
        SourcePosition position = variableAccess.getPosition();
        for (DefUseChain chain : du.getChains(variable)) {
            CtElement firstElement = chain.getFirstChainElement().getElement();
            if (firstElement != null && firstElement.getPosition().getLine() > position.getLine()) {
                return true;
            }
            ChainElement chainElement = chain.find((CtElement)variableAccess);
            if (chainElement == null || chain.outgoingEdgesOf(chainElement).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

