/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.interval;

import com.google.common.collect.Range;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.reference.CtTypeReference;

public class IntervalBuilder {
    private IntervalBuilder() {
    }

    @Nullable
    public static Range<Double> generateDoubleIntervalFromAst(CtBinaryOperator<?> binaryOperator, boolean isThenBranch) {
        String name;
        CtTypeReference typeReference;
        double value;
        BinaryOperatorKind kind = binaryOperator.getKind();
        if (binaryOperator.getLeftHandOperand() instanceof CtVariableAccess) {
            value = IntervalBuilder.getDouble(binaryOperator.getRightHandOperand());
            typeReference = binaryOperator.getLeftHandOperand().getType();
        } else if (binaryOperator.getRightHandOperand() instanceof CtVariableAccess) {
            value = IntervalBuilder.getDouble(binaryOperator.getLeftHandOperand());
            typeReference = binaryOperator.getRightHandOperand().getType();
            kind = IntervalBuilder.reverse(kind);
        } else {
            return null;
        }
        if (Double.isNaN(value) || typeReference == null) {
            return null;
        }
        if (!isThenBranch) {
            kind = kind == BinaryOperatorKind.NE ? BinaryOperatorKind.EQ : IntervalBuilder.reverse(kind);
        }
        return (name = typeReference.getSimpleName().toLowerCase()).equals("double") || name.equals("float") ? IntervalBuilder.generateDoubleInterval(kind, value) : null;
    }

    private static double getDouble(CtExpression<?> expression) {
        if ((expression = (CtExpression)expression.partiallyEvaluate()) instanceof CtLiteral) {
            CtLiteral literal = (CtLiteral)expression;
            return literal.getValue() instanceof Number ? ((Number)literal.getValue()).doubleValue() : Double.NaN;
        }
        if (expression instanceof CtUnaryOperator && ((CtUnaryOperator)expression).getKind() == UnaryOperatorKind.NEG) {
            double result = IntervalBuilder.getDouble(expression);
            return Double.isNaN(result) ? result : -result;
        }
        return Double.NaN;
    }

    private static BinaryOperatorKind reverse(BinaryOperatorKind kind) {
        switch (kind) {
            case GT: {
                return BinaryOperatorKind.LE;
            }
            case GE: {
                return BinaryOperatorKind.LT;
            }
            case LE: {
                return BinaryOperatorKind.GT;
            }
            case LT: {
                return BinaryOperatorKind.GE;
            }
        }
        return kind;
    }

    private static Range<Double> generateDoubleInterval(BinaryOperatorKind kind, Double value) {
        switch (kind) {
            case GT: {
                return Range.greaterThan((Comparable)value);
            }
            case GE: {
                return Range.atLeast((Comparable)value);
            }
            case LE: {
                return Range.atMost((Comparable)value);
            }
            case LT: {
                return Range.lessThan((Comparable)value);
            }
            case EQ: {
                return Range.singleton((Comparable)value);
            }
        }
        return null;
    }
}

