/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.interprocedural.strategy;

import com.pvsstudio.dataflow.graph.InvocationEdge;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import com.pvsstudio.dataflow.interprocedural.strategy.CallSiteStrategy;
import com.pvsstudio.dataflow.taint.GraphProvider;
import com.pvsstudio.dataflow.taint.cache.VisitedCallsController;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtElement;

public class ExecutableCallStrategy
extends CallSiteStrategy<ExecutableCall> {
    private final VisitedCallsController callsController;
    private final GraphProvider graphProvider;

    public ExecutableCallStrategy(ExecutableCall callSite, VisitedCallsController callsController, GraphProvider graphProvider) {
        super(callSite);
        this.callsController = callsController;
        this.graphProvider = graphProvider;
    }

    @Override
    public Collection<CtElement> getInitialElements() {
        List<CtAbstractInvocation<?>> invocations = this.getBackwardInvocations((ExecutableCall)this.callSite);
        LinkedList<CtElement> result = new LinkedList<CtElement>();
        invocations.stream().filter(inv -> ((ExecutableCall)this.callSite).getParameterPos() < inv.getArguments().size()).filter(inv -> !this.callsController.isVisited((ExecutableCall)this.callSite, (CtAbstractInvocation<?>)inv)).forEach(inv -> {
            this.callsController.addVisitedExecutable((ExecutableCall)this.callSite, (CtAbstractInvocation<?>)inv);
            result.add((CtElement)inv.getArguments().get(((ExecutableCall)this.callSite).getParameterPos()));
        });
        return result;
    }

    private List<CtAbstractInvocation<?>> getBackwardInvocations(@NotNull ExecutableCall execCall) {
        Optional<CtAbstractInvocation> returnedInvocation = Optional.of(execCall).filter(ExecutableReturn.class::isInstance).map(IntermediateCallSite::getParent).filter(InvocationCall.class::isInstance).map(x -> (CtAbstractInvocation)((InvocationCall)x).get());
        return returnedInvocation.map(List::of).orElseGet(() -> this.graphProvider.getCallGraph().getEdgesBetween(execCall.getSignature(), execCall.getMethod()).stream().filter(InvocationEdge.class::isInstance).map(InvocationEdge.class::cast).map(InvocationEdge::getInvocation).collect(Collectors.toList()));
    }
}

