/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.interprocedural;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.Parameterized;
import spoon.reflect.declaration.CtExecutable;

public class ExecutableCall
extends IntermediateCallSite<CtExecutable<?>>
implements Parameterized {
    private final Supplier<MethodSignature> methodSupplier;
    private final int parameterPos;

    public ExecutableCall(CallSite<?> caller, CtExecutable<?> executable, int parameterPos) {
        this(caller, executable, parameterPos, 0);
    }

    protected ExecutableCall(CallSite<?> caller, CtExecutable<?> executable, int parameterPos, int depth) {
        super(executable, depth, executable, (Supplier<MethodSignature>)Suppliers.memoize(() -> MethodSignature.of(executable)), caller);
        this.methodSupplier = caller.signatureSupplier;
        this.parameterPos = parameterPos;
    }

    public MethodSignature getMethod() {
        return (MethodSignature)this.methodSupplier.get();
    }

    @Override
    public int getParameterPos() {
        return this.parameterPos;
    }

    public String toString() {
        return "ExecutableCall{caller=" + String.valueOf(this.caller) + ", executable=" + String.valueOf(this.executable) + ", method=" + String.valueOf(this.getMethod()) + ", parameterPos=" + this.parameterPos + "}";
    }
}

