/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.interprocedural;

import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.interprocedural.CallSite;
import com.pvsstudio.dataflow.interprocedural.ExecutableCall;
import com.pvsstudio.dataflow.interprocedural.ExecutableReturn;
import com.pvsstudio.dataflow.interprocedural.IntermediateCallSite;
import com.pvsstudio.dataflow.interprocedural.InvocationCall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallSiteSequenceController {
    private CallSiteSequenceController() {
    }

    public static boolean isNotRecursion(@NotNull InvocationCall invocationCall) {
        CallSite callSite = invocationCall;
        MethodSignature signature = callSite.getSignature();
        do {
            if (!((callSite = ((IntermediateCallSite)callSite).getParent()) instanceof InvocationCall) || !callSite.getSignature().equals(signature)) continue;
            return false;
        } while (callSite instanceof IntermediateCallSite && callSite.getDepth() != 0);
        return true;
    }

    public static boolean isNotRecursion(@NotNull ExecutableCall executableCallSite) {
        CallSite callSite = executableCallSite;
        MethodSignature signature = callSite.getSignature();
        do {
            if (!((callSite = ((IntermediateCallSite)callSite).getParent()) instanceof ExecutableCall) || !signature.equals(callSite.getSignature()) || callSite.getDepth() != 0) continue;
            return false;
        } while (callSite instanceof IntermediateCallSite);
        return true;
    }

    @Nullable
    public static CallSite<?> getUnprocessedCallSite(CallSite<?> curCallSite) {
        if (!(curCallSite instanceof ExecutableReturn) || curCallSite.getDepth() == 0) {
            return curCallSite;
        }
        CallSite<?> startCallSite = curCallSite;
        do {
            if (!(curCallSite instanceof InvocationCall) || curCallSite.getDepth() != startCallSite.getDepth()) continue;
            return curCallSite;
        } while ((curCallSite = ((IntermediateCallSite)curCallSite).getParent()) instanceof IntermediateCallSite);
        return curCallSite;
    }
}

