/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.intermediate;

import com.pvsstudio.dataflow.intermediate.Field;
import com.pvsstudio.dataflow.intermediate.FieldImpl;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableImpl;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtVariableReference;

public class VariableFactory {
    private VariableFactory() {
    }

    public static Variable parseFromAst(@Nullable CtElement variable) {
        if (variable instanceof CtArrayAccess) {
            variable = ((CtArrayAccess)variable).getTarget();
        }
        if (variable instanceof CtVariableAccess) {
            return VariableFactory.unboxVariableAccess((CtVariableAccess)variable);
        }
        if (variable instanceof CtVariable) {
            return new VariableImpl(((CtVariable)variable).getReference(), variable.getPosition());
        }
        if (variable instanceof CtVariableReference) {
            return new VariableImpl((CtVariableReference)variable, variable.getPosition());
        }
        return null;
    }

    @Nullable
    private static Variable unboxVariableAccess(@Nullable CtVariableAccess<?> variableAccess) {
        if (variableAccess == null) {
            return null;
        }
        if (!(variableAccess instanceof CtFieldAccess)) {
            return new VariableImpl(variableAccess.getVariable(), variableAccess.getPosition());
        }
        LinkedList<CtVariableAccess> accesses = new LinkedList<CtVariableAccess>();
        while (variableAccess != null) {
            accesses.add(0, variableAccess);
            if (variableAccess instanceof CtFieldAccess && ((CtFieldAccess)variableAccess).getTarget() instanceof CtVariableAccess) {
                variableAccess = (CtVariableAccess)((CtFieldAccess)variableAccess).getTarget();
                continue;
            }
            variableAccess = null;
        }
        VariableImpl result = null;
        for (int i = 0; i < accesses.size(); ++i) {
            CtVariableAccess access = (CtVariableAccess)accesses.get(i);
            CtVariableReference variable = access.getVariable();
            result = i == 0 ? new VariableImpl(variable, access.getPosition()) : new FieldImpl(result, variable, access.getPosition());
        }
        return result;
    }

    public static Field swappedOwner(Variable owner, Field fieldWithOldOwner) {
        LinkedList<Field> variables = new LinkedList<Field>();
        while (fieldWithOldOwner != null) {
            variables.add(0, fieldWithOldOwner);
            if (!(fieldWithOldOwner.getOwner() instanceof Field)) {
                fieldWithOldOwner = null;
                continue;
            }
            fieldWithOldOwner = (Field)fieldWithOldOwner.getOwner();
        }
        FieldImpl result = null;
        for (Variable variable : variables) {
            result = new FieldImpl(result == null ? owner : result, variable.getReference(), owner.getPosition());
        }
        return result;
    }
}

