/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.graph;

import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.defuse.element.ChainElementIf;
import com.pvsstudio.dataflow.graph.FlowResult;
import com.pvsstudio.dataflow.traversal.DFSAnyPath;
import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.NodeKind;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;

public class GraphUtils {
    public static EnumSet<FlowResult> getNodeRelationToIf(@NotNull ChainElement node, @NotNull ChainElementIf ifNode, @NotNull ControlFlowGraph graph) {
        EnumSet<FlowResult> res = EnumSet.noneOf(FlowResult.class);
        if (node.getElement() == null) {
            assert (false);
            return res;
        }
        List branches = ifNode.getNode().next();
        if (branches.isEmpty()) {
            return EnumSet.of(FlowResult.THEN_ACCESSIBLE, FlowResult.ELSE_ACCESSIBLE);
        }
        CtBlock thenBlock = (CtBlock)((CtIf)ifNode.getElement().getParent()).getThenStatement();
        CtBlock elseBlock = (CtBlock)((CtIf)ifNode.getElement().getParent()).getElseStatement();
        if (node.getElement().getParent(new ReferenceFilter<CtBlock>(thenBlock)) == thenBlock) {
            return EnumSet.of(FlowResult.THEN);
        }
        if (elseBlock != null && node.getElement().getParent(new ReferenceFilter<CtBlock>(elseBlock)) == elseBlock) {
            return EnumSet.of(FlowResult.ELSE);
        }
        ControlFlowNode thenNode = (ControlFlowNode)branches.get(0);
        boolean thenPath = new DFSAnyPath((Graph<ControlFlowNode, ControlFlowEdge>)graph, thenNode, node.getNode()).hasPath();
        if (thenPath) {
            res.add(FlowResult.THEN_ACCESSIBLE);
        }
        if (elseBlock == null) {
            res.add(FlowResult.ELSE_ACCESSIBLE);
            return res;
        }
        ControlFlowNode elseNode = (ControlFlowNode)branches.get(1);
        boolean elsePath = new DFSAnyPath((Graph<ControlFlowNode, ControlFlowEdge>)graph, elseNode, node.getNode()).hasPath();
        if (elsePath) {
            res.add(FlowResult.ELSE_ACCESSIBLE);
        }
        return res;
    }

    @Nullable
    public static ControlFlowNode getNodeFromThenBranch(ControlFlowNode relationNode) {
        if (!(relationNode.getStatement().getParent() instanceof CtIf)) {
            return null;
        }
        CtIf ctIf = (CtIf)relationNode.getStatement().getParent();
        CtStatement thenBranch = ctIf.getThenStatement();
        List nextNodes = relationNode.next().stream().filter(node -> node.getKind() == NodeKind.BLOCK_BEGIN).map(node -> (ControlFlowNode)node.next().get(0)).collect(Collectors.toList());
        for (ControlFlowNode node2 : nextNodes) {
            if (node2.getKind() == NodeKind.TRY) {
                return node2.next().stream().filter(n -> n.getKind() == NodeKind.BLOCK_BEGIN).map(n -> (ControlFlowNode)n.next().get(0)).filter(n -> n.getStatement() != null).filter(n -> ((CtTry)n.getStatement().getParent(CtTry.class)).getBody() != null).filter(n -> ((CtTry)n.getStatement().getParent(CtTry.class)).getBody().getParent(CtBlock.class) == thenBranch).findFirst().orElse(null);
            }
            if (node2.getStatement() == null || node2.getStatement().getParent(CtBlock.class) != thenBranch) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    public static ControlFlowNode getNodeFromElseBranch(ControlFlowNode relationNode) {
        if (!(relationNode.getStatement().getParent() instanceof CtIf)) {
            return null;
        }
        CtIf ctIf = (CtIf)relationNode.getStatement().getParent();
        CtStatement elseBranch = ctIf.getElseStatement();
        if (elseBranch == null) {
            return relationNode.next().stream().filter(node -> node.getKind() == NodeKind.CONVERGE).map(node -> (ControlFlowNode)node.next().get(0)).findFirst().orElse(null);
        }
        List nextNodes = relationNode.next().stream().filter(node -> node.getKind() == NodeKind.BLOCK_BEGIN).map(node -> (ControlFlowNode)node.next().get(0)).collect(Collectors.toList());
        for (ControlFlowNode node2 : nextNodes) {
            if (node2.getStatement() == null || node2.getStatement().getParent(CtBlock.class) != elseBranch) continue;
            return node2;
        }
        return null;
    }

    private static class ReferenceFilter<T extends CtElement>
    implements Filter<T> {
        private final T ref;

        public ReferenceFilter(T element) {
            this.ref = element;
        }

        public boolean matches(T element) {
            return element == this.ref;
        }
    }
}

