/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.graph;

import com.pvsstudio.dataflow.call.CallGraph;
import com.pvsstudio.dataflow.call.CallGraphImpl;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.DefUseGraphBuilder;
import com.pvsstudio.dataflow.graph.GraphModel;
import fr.inria.controlflow.ControlFlowBuilder;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ExceptionControlFlowStrategy;
import fr.inria.controlflow.NaiveExceptionControlFlowStrategy;
import fr.inria.controlflow.UnsupportedReturnException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;

public class GraphModelImpl
implements GraphModel {
    private static final Logger logger = LoggerFactory.getLogger(GraphModelImpl.class);
    private final Map<MethodSignature, ControlFlowGraph> controlGraphs = new HashMap<MethodSignature, ControlFlowGraph>();
    private final Map<MethodSignature, DefUseGraph> defuseGraphs = new HashMap<MethodSignature, DefUseGraph>();
    private final CallGraph callGraph = new CallGraphImpl();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    @Nullable
    public DefUseGraph getDefUseGraph(@Nullable CtExecutable<?> method) {
        return this.getGraph(method, this.defuseGraphs);
    }

    @Override
    @Nullable
    public ControlFlowGraph getControlGraph(CtExecutable<?> method) {
        return this.getGraph(method, this.controlGraphs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <G> G getGraph(@Nullable CtExecutable<?> executable, Map<MethodSignature, G> graphs) {
        if (executable == null) {
            return null;
        }
        MethodSignature signature = MethodSignature.of(executable);
        if (signature == null) {
            return null;
        }
        try {
            this.lock.lock();
            if (!graphs.containsKey(signature)) {
                this.buildExecutableGraphs(executable, signature);
            }
        }
        finally {
            this.lock.unlock();
        }
        return graphs.get(signature);
    }

    private void buildExecutableGraphs(CtExecutable<?> executable, MethodSignature signature) {
        if (executable == null || signature == null) {
            return;
        }
        if (executable instanceof CtMethod && (((CtMethod)executable).isAbstract() || ((CtMethod)executable).isNative())) {
            return;
        }
        try {
            ControlFlowGraph cfg = this.buildControlFlowGraph(executable);
            DefUseGraph dug = this.buildDefUseGraph(cfg);
            this.controlGraphs.put(signature, cfg);
            this.defuseGraphs.put(signature, dug);
        }
        catch (UnsupportedReturnException ex) {
            logger.error("Found unsupported return statement inside a try-catch-finally block in the method: {}", (Object)executable.getSimpleName());
        }
        catch (RuntimeException ex) {
            logger.error("Exception on dataflow build: ", (Throwable)ex);
        }
    }

    private ControlFlowGraph buildControlFlowGraph(CtExecutable<?> executable) {
        ControlFlowBuilder cfgBuilder = new ControlFlowBuilder();
        cfgBuilder.setExceptionControlFlowStrategy((ExceptionControlFlowStrategy)new NaiveExceptionControlFlowStrategy());
        cfgBuilder.build(executable);
        return cfgBuilder.getResult();
    }

    private DefUseGraph buildDefUseGraph(ControlFlowGraph cfg) {
        DefUseGraphBuilder duGraphBuilder = new DefUseGraphBuilder();
        duGraphBuilder.build(cfg);
        return duGraphBuilder.getResult();
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

