/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse.element;

import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.NodeKind;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

public class ChainElementImpl
implements ChainElement {
    private final ControlFlowNode controlFlowNode;

    protected ChainElementImpl(ControlFlowNode cfgNode) {
        this.controlFlowNode = cfgNode;
    }

    @Override
    public CtElement getElement() {
        return this.controlFlowNode.getStatement();
    }

    @Override
    public ControlFlowNode getNode() {
        return this.controlFlowNode;
    }

    public String toString() {
        return this.getNode().toString();
    }

    @Override
    public List<CtVariableAccess<?>> getVariableUsages(final Variable owner) {
        final ArrayList res = new ArrayList();
        new CtScanner(){

            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                this.visitVariableAccess((CtVariableAccess<?>)variableRead);
            }

            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                this.visitVariableAccess((CtVariableAccess<?>)fieldRead);
            }

            public <T> void visitCtVariableWrite(CtVariableWrite<T> write) {
                this.visitVariableAccess((CtVariableAccess<?>)write);
            }

            public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
                this.visitVariableAccess((CtVariableAccess<?>)fieldWrite);
            }

            private void visitVariableAccess(CtVariableAccess<?> variableAccess) {
                if (owner.equals(VariableFactory.parseFromAst(variableAccess))) {
                    res.add(variableAccess);
                }
            }
        }.scan(this.getElement());
        return res;
    }

    @Override
    public List<CtVariableAccess<?>> getDefiningVariables(final Variable owner) {
        final ArrayList res = new ArrayList();
        new CtScanner(){
            boolean isInTargetOwnerAssignment = false;

            private CtVariableAccess<?> getVariableAccess(CtAssignment<?, ?> ass) {
                CtExpression left = ass.getAssigned();
                while (left instanceof CtArrayAccess) {
                    left = ((CtArrayAccess)left).getTarget();
                }
                if (left instanceof CtVariableAccess) {
                    return (CtVariableAccess)left;
                }
                return null;
            }

            public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
                Variable variable = VariableFactory.parseFromAst(this.getVariableAccess(assignement));
                if (owner.equals(variable)) {
                    this.isInTargetOwnerAssignment = true;
                    this.scan((CtElement)assignement.getAssignment());
                    this.isInTargetOwnerAssignment = false;
                }
            }

            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                if (this.isInTargetOwnerAssignment) {
                    res.add(variableRead);
                }
            }

            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                if (this.isInTargetOwnerAssignment) {
                    res.add(fieldRead);
                }
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
                CtElement parent = localVariable.getParent();
                if (parent instanceof CtForEach) {
                    CtExpression exp = ((CtForEach)parent).getExpression();
                    if (exp instanceof CtVariableRead) {
                        res.add((CtVariableRead)exp);
                    }
                } else {
                    this.isInTargetOwnerAssignment = true;
                    this.scan((CtElement)localVariable.getDefaultExpression());
                    this.isInTargetOwnerAssignment = false;
                }
            }

            public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
                this.visitCtAssignment((CtAssignment<T, A>)assignment);
                Variable variable = VariableFactory.parseFromAst(this.getVariableAccess((CtAssignment<?, ?>)assignment));
                if (owner.equals(variable)) {
                    if (variable.getReference().getParent() instanceof CtVariableAccess) {
                        res.add((CtVariableAccess)variable.getReference().getParent());
                    }
                    this.isInTargetOwnerAssignment = true;
                    this.scan((CtElement)assignment.getAssignment());
                    this.isInTargetOwnerAssignment = false;
                }
            }
        }.scan(this.getElement());
        return res;
    }

    @Override
    public boolean isBegin() {
        return this.controlFlowNode.getKind() == NodeKind.BEGIN;
    }
}

