/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse.chain.build;

import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.chain.DefUseChainEdge;
import com.pvsstudio.dataflow.defuse.chain.DefUseChainImpl;
import com.pvsstudio.dataflow.defuse.chain.EdgeCollection;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtElement;

public class SimpleDefUseChainBuilder {
    private static final EdgeCollection edgeCollection = EdgeCollection.getInstance();
    private final DefUseChainImpl result;
    private final List<ChainElement> lastAddedElements = new ArrayList<ChainElement>();

    public SimpleDefUseChainBuilder(Variable owner, ChainElement element, @Nullable CtElement defaultExpression) {
        this.lastAddedElements.add(element);
        this.result = new DefUseChainImpl(element, owner, defaultExpression);
    }

    @NotNull
    public DefUseChainImpl getResult() {
        return this.result;
    }

    public ChainElement getLastAddedElement() {
        return this.lastAddedElements.get(this.lastAddedElements.size() - 1);
    }

    public void stepBack() {
        if (this.lastAddedElements.size() > 1) {
            this.lastAddedElements.remove(this.lastAddedElements.size() - 1);
        }
    }

    public boolean isEmpty() {
        return this.lastAddedElements.size() <= 1;
    }

    public void addVertex(ChainElement element) {
        if (this.result.addVertex(element)) {
            ChainElement last = this.getLastAddedElement();
            DefUseChainEdge edge = edgeCollection.getEdge(last, element);
            this.result.addEdge(last, element, (Object)edge);
            this.lastAddedElements.add(element);
        }
    }

    public void addElementsFromOtherChain(ChainElement lastElement, DefUseChain other, List<ChainElement> vertexes, DefUseGraph completedChains) {
        ArrayList<ChainElement> memory;
        ArrayList<ChainElement> newVertexes = new ArrayList<ChainElement>();
        vertexes.forEach(vertex -> {
            if (other.containsVertex(vertex)) {
                this.result.addVertex(vertex);
                this.result.addEdge(lastElement, vertex, (Object)edgeCollection.getEdge(this.getLastAddedElement(), (ChainElement)vertex));
                newVertexes.add((ChainElement)vertex);
                this.addParentToTargetChains(completedChains, (ChainElement)vertex);
            }
        });
        vertexes = newVertexes;
        do {
            memory = new ArrayList<ChainElement>();
            for (ChainElement currentVertex : vertexes) {
                other.edgeSet().stream().filter(edge -> edge.getSource().getNode().equals(currentVertex.getNode())).map(DefUseChainEdge::getTarget).forEach(target -> {
                    boolean addingResult = this.result.addVertex(target);
                    this.result.addEdge(currentVertex, target, (Object)edgeCollection.getEdge(currentVertex, (ChainElement)target));
                    this.addParentToTargetChains(completedChains, (ChainElement)target);
                    if (addingResult) {
                        memory.add((ChainElement)target);
                    }
                });
            }
        } while (!(vertexes = memory).isEmpty());
    }

    private void addParentToTargetChains(DefUseGraph completedChains, ChainElement start) {
        completedChains.getVariables().stream().map(completedChains::getChains).flatMap(Collection::stream).filter(chain -> chain.getFirstChainElement().equals(start)).filter(DefUseChainImpl.class::isInstance).map(DefUseChainImpl.class::cast).forEach(chain -> chain.addParent(this.result));
    }

    public void addParent(@Nullable SimpleDefUseChainBuilder parentBuilder) {
        if (parentBuilder == null) {
            return;
        }
        this.result.addParent(parentBuilder.result);
    }

    public void addParents(@Nullable Collection<DefUseChain> parents) {
        if (parents == null) {
            return;
        }
        parents.forEach(this.result::addParent);
    }
}

